// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class UpdateFindingsFilterRequest private constructor(builder: BuilderImpl) {
    /**
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    val action: FindingsFilterAction? = builder.action
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val description: String? = builder.description
    /**
     * The criteria to use to filter findings.
     */
    val findingCriteria: FindingCriteria? = builder.findingCriteria
    /**
     * The unique identifier for the Amazon Macie resource or account that the request applies to.
     */
    val id: String? = builder.id
    /**
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val name: String? = builder.name
    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    val position: Int? = builder.position

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFindingsFilterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFindingsFilterRequest(")
        append("action=$action,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("findingCriteria=$findingCriteria,")
        append("id=$id,")
        append("name=$name,")
        append("position=$position)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingCriteria?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (position ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFindingsFilterRequest

        if (action != other.action) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (findingCriteria != other.findingCriteria) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (position != other.position) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFindingsFilterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFindingsFilterRequest
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        fun action(action: FindingsFilterAction): FluentBuilder
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun description(description: String): FluentBuilder
        /**
         * The criteria to use to filter findings.
         */
        fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder
        /**
         * The unique identifier for the Amazon Macie resource or account that the request applies to.
         */
        fun id(id: String): FluentBuilder
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun name(name: String): FluentBuilder
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        fun position(position: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        var action: FindingsFilterAction?
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        var clientToken: String?
        /**
         * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var description: String?
        /**
         * The criteria to use to filter findings.
         */
        var findingCriteria: FindingCriteria?
        /**
         * The unique identifier for the Amazon Macie resource or account that the request applies to.
         */
        var id: String?
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var name: String?
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        var position: Int?

        fun build(): UpdateFindingsFilterRequest
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FindingCriteria] inside the given [block]
         */
        fun findingCriteria(block: FindingCriteria.DslBuilder.() -> kotlin.Unit) {
            this.findingCriteria = FindingCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: FindingsFilterAction? = null
        override var clientToken: String? = null
        override var description: String? = null
        override var findingCriteria: FindingCriteria? = null
        override var id: String? = null
        override var name: String? = null
        override var position: Int? = null

        constructor(x: UpdateFindingsFilterRequest) : this() {
            this.action = x.action
            this.clientToken = x.clientToken
            this.description = x.description
            this.findingCriteria = x.findingCriteria
            this.id = x.id
            this.name = x.name
            this.position = x.position
        }

        override fun build(): UpdateFindingsFilterRequest = UpdateFindingsFilterRequest(this)
        override fun action(action: FindingsFilterAction): FluentBuilder = apply { this.action = action }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder = apply { this.findingCriteria = findingCriteria }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun position(position: Int): FluentBuilder = apply { this.position = position }
    }
}
