// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides data for a specific usage metric and the corresponding quota for an Amazon Macie account.
 */
class UsageByAccount private constructor(builder: BuilderImpl) {
    /**
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     */
    val currency: Currency? = builder.currency
    /**
     * The estimated value for the metric.
     */
    val estimatedCost: String? = builder.estimatedCost
    /**
     * The current value for the quota that corresponds to the metric specified by the type field.
     */
    val serviceLimit: ServiceLimit? = builder.serviceLimit
    /**
     * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     */
    val type: UsageType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageByAccount = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageByAccount(")
        append("currency=$currency,")
        append("estimatedCost=$estimatedCost,")
        append("serviceLimit=$serviceLimit,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currency?.hashCode() ?: 0
        result = 31 * result + (estimatedCost?.hashCode() ?: 0)
        result = 31 * result + (serviceLimit?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageByAccount

        if (currency != other.currency) return false
        if (estimatedCost != other.estimatedCost) return false
        if (serviceLimit != other.serviceLimit) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageByAccount = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageByAccount
        /**
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         */
        fun currency(currency: Currency): FluentBuilder
        /**
         * The estimated value for the metric.
         */
        fun estimatedCost(estimatedCost: String): FluentBuilder
        /**
         * The current value for the quota that corresponds to the metric specified by the type field.
         */
        fun serviceLimit(serviceLimit: ServiceLimit): FluentBuilder
        /**
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         */
        fun type(type: UsageType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         */
        var currency: Currency?
        /**
         * The estimated value for the metric.
         */
        var estimatedCost: String?
        /**
         * The current value for the quota that corresponds to the metric specified by the type field.
         */
        var serviceLimit: ServiceLimit?
        /**
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         */
        var type: UsageType?

        fun build(): UsageByAccount
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ServiceLimit] inside the given [block]
         */
        fun serviceLimit(block: ServiceLimit.DslBuilder.() -> kotlin.Unit) {
            this.serviceLimit = ServiceLimit.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currency: Currency? = null
        override var estimatedCost: String? = null
        override var serviceLimit: ServiceLimit? = null
        override var type: UsageType? = null

        constructor(x: UsageByAccount) : this() {
            this.currency = x.currency
            this.estimatedCost = x.estimatedCost
            this.serviceLimit = x.serviceLimit
            this.type = x.type
        }

        override fun build(): UsageByAccount = UsageByAccount(this)
        override fun currency(currency: Currency): FluentBuilder = apply { this.currency = currency }
        override fun estimatedCost(estimatedCost: String): FluentBuilder = apply { this.estimatedCost = estimatedCost }
        override fun serviceLimit(serviceLimit: ServiceLimit): FluentBuilder = apply { this.serviceLimit = serviceLimit }
        override fun type(type: UsageType): FluentBuilder = apply { this.type = type }
    }
}
