// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides quota and aggregated usage data for an Amazon Macie account.
 */
class UsageRecord private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that the data applies to.
     */
    val accountId: String? = builder.accountId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
     */
    val freeTrialStartDate: Instant? = builder.freeTrialStartDate
    /**
     * An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.
     */
    val usage: List<UsageByAccount>? = builder.usage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageRecord = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecord(")
        append("accountId=$accountId,")
        append("freeTrialStartDate=$freeTrialStartDate,")
        append("usage=$usage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (freeTrialStartDate?.hashCode() ?: 0)
        result = 31 * result + (usage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageRecord

        if (accountId != other.accountId) return false
        if (freeTrialStartDate != other.freeTrialStartDate) return false
        if (usage != other.usage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageRecord = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageRecord
        /**
         * The unique identifier for the Amazon Web Services account that the data applies to.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
         */
        fun freeTrialStartDate(freeTrialStartDate: Instant): FluentBuilder
        /**
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.
         */
        fun usage(usage: List<UsageByAccount>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that the data applies to.
         */
        var accountId: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
         */
        var freeTrialStartDate: Instant?
        /**
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.
         */
        var usage: List<UsageByAccount>?

        fun build(): UsageRecord
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var freeTrialStartDate: Instant? = null
        override var usage: List<UsageByAccount>? = null

        constructor(x: UsageRecord) : this() {
            this.accountId = x.accountId
            this.freeTrialStartDate = x.freeTrialStartDate
            this.usage = x.usage
        }

        override fun build(): UsageRecord = UsageRecord(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun freeTrialStartDate(freeTrialStartDate: Instant): FluentBuilder = apply { this.freeTrialStartDate = freeTrialStartDate }
        override fun usage(usage: List<UsageByAccount>): FluentBuilder = apply { this.usage = usage }
    }
}
