// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a condition for filtering the results of a query for quota and usage data for one or more Amazon Macie accounts.
 */
class UsageStatisticsFilter private constructor(builder: BuilderImpl) {
    /**
     * The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
     */
    val comparator: UsageStatisticsFilterComparator? = builder.comparator
    /**
     * The field to use in the condition.
     */
    val key: UsageStatisticsFilterKey? = builder.key
    /**
     * An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value. Valid values for each supported field are: accountId - The unique identifier for an Amazon Web Services account. freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account. serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota. total - A string that represents the current estimated cost for an account.
     */
    val values: List<String>? = builder.values

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageStatisticsFilter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageStatisticsFilter(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageStatisticsFilter

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageStatisticsFilter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageStatisticsFilter
        /**
         * The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
         */
        fun comparator(comparator: UsageStatisticsFilterComparator): FluentBuilder
        /**
         * The field to use in the condition.
         */
        fun key(key: UsageStatisticsFilterKey): FluentBuilder
        /**
         * An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value. Valid values for each supported field are: accountId - The unique identifier for an Amazon Web Services account. freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account. serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota. total - A string that represents the current estimated cost for an account.
         */
        fun values(values: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
         */
        var comparator: UsageStatisticsFilterComparator?
        /**
         * The field to use in the condition.
         */
        var key: UsageStatisticsFilterKey?
        /**
         * An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value. Valid values for each supported field are: accountId - The unique identifier for an Amazon Web Services account. freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account. serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota. total - A string that represents the current estimated cost for an account.
         */
        var values: List<String>?

        fun build(): UsageStatisticsFilter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comparator: UsageStatisticsFilterComparator? = null
        override var key: UsageStatisticsFilterKey? = null
        override var values: List<String>? = null

        constructor(x: UsageStatisticsFilter) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.values = x.values
        }

        override fun build(): UsageStatisticsFilter = UsageStatisticsFilter(this)
        override fun comparator(comparator: UsageStatisticsFilterComparator): FluentBuilder = apply { this.comparator = comparator }
        override fun key(key: UsageStatisticsFilterKey): FluentBuilder = apply { this.key = key }
        override fun values(values: List<String>): FluentBuilder = apply { this.values = values }
    }
}
