// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides aggregated data for an Amazon Macie usage metric. The value for the metric reports estimated usage data for an account for the preceding 30 days or the current calendar month to date, depending on the time period (timeRange) specified in the request.
 */
class UsageTotal private constructor(builder: BuilderImpl) {
    /**
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     */
    val currency: Currency? = builder.currency
    /**
     * The estimated value for the metric.
     */
    val estimatedCost: String? = builder.estimatedCost
    /**
     * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     */
    val type: UsageType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageTotal = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageTotal(")
        append("currency=$currency,")
        append("estimatedCost=$estimatedCost,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currency?.hashCode() ?: 0
        result = 31 * result + (estimatedCost?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageTotal

        if (currency != other.currency) return false
        if (estimatedCost != other.estimatedCost) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageTotal = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageTotal
        /**
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         */
        fun currency(currency: Currency): FluentBuilder
        /**
         * The estimated value for the metric.
         */
        fun estimatedCost(estimatedCost: String): FluentBuilder
        /**
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         */
        fun type(type: UsageType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         */
        var currency: Currency?
        /**
         * The estimated value for the metric.
         */
        var estimatedCost: String?
        /**
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         */
        var type: UsageType?

        fun build(): UsageTotal
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currency: Currency? = null
        override var estimatedCost: String? = null
        override var type: UsageType? = null

        constructor(x: UsageTotal) : this() {
            this.currency = x.currency
            this.estimatedCost = x.estimatedCost
            this.type = x.type
        }

        override fun build(): UsageTotal = UsageTotal(this)
        override fun currency(currency: Currency): FluentBuilder = apply { this.currency = currency }
        override fun estimatedCost(estimatedCost: String): FluentBuilder = apply { this.estimatedCost = estimatedCost }
        override fun type(type: UsageType): FluentBuilder = apply { this.type = type }
    }
}
