// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the type and other characteristics of an entity that performed an action on an affected resource.
 */
class UserIdentity private constructor(builder: BuilderImpl) {
    /**
     * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
     */
    val assumedRole: AssumedRole? = builder.assumedRole
    /**
     * If the action was performed using the credentials for another Amazon Web Services account, the details of that account.
     */
    val awsAccount: AwsAccount? = builder.awsAccount
    /**
     * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.
     */
    val awsService: AwsService? = builder.awsService
    /**
     * If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
     */
    val federatedUser: FederatedUser? = builder.federatedUser
    /**
     * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.
     */
    val iamUser: IamUser? = builder.iamUser
    /**
     * If the action was performed using the credentials for your Amazon Web Services account, the details of your account.
     */
    val root: UserIdentityRoot? = builder.root
    /**
     * The type of entity that performed the action.
     */
    val type: UserIdentityType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UserIdentity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdentity(")
        append("assumedRole=$assumedRole,")
        append("awsAccount=$awsAccount,")
        append("awsService=$awsService,")
        append("federatedUser=$federatedUser,")
        append("iamUser=$iamUser,")
        append("root=$root,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRole?.hashCode() ?: 0
        result = 31 * result + (awsAccount?.hashCode() ?: 0)
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (federatedUser?.hashCode() ?: 0)
        result = 31 * result + (iamUser?.hashCode() ?: 0)
        result = 31 * result + (root?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UserIdentity

        if (assumedRole != other.assumedRole) return false
        if (awsAccount != other.awsAccount) return false
        if (awsService != other.awsService) return false
        if (federatedUser != other.federatedUser) return false
        if (iamUser != other.iamUser) return false
        if (root != other.root) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UserIdentity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UserIdentity
        /**
         * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        fun assumedRole(assumedRole: AssumedRole): FluentBuilder
        /**
         * If the action was performed using the credentials for another Amazon Web Services account, the details of that account.
         */
        fun awsAccount(awsAccount: AwsAccount): FluentBuilder
        /**
         * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.
         */
        fun awsService(awsService: AwsService): FluentBuilder
        /**
         * If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        fun federatedUser(federatedUser: FederatedUser): FluentBuilder
        /**
         * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.
         */
        fun iamUser(iamUser: IamUser): FluentBuilder
        /**
         * If the action was performed using the credentials for your Amazon Web Services account, the details of your account.
         */
        fun root(root: UserIdentityRoot): FluentBuilder
        /**
         * The type of entity that performed the action.
         */
        fun type(type: UserIdentityType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        var assumedRole: AssumedRole?
        /**
         * If the action was performed using the credentials for another Amazon Web Services account, the details of that account.
         */
        var awsAccount: AwsAccount?
        /**
         * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.
         */
        var awsService: AwsService?
        /**
         * If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        var federatedUser: FederatedUser?
        /**
         * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.
         */
        var iamUser: IamUser?
        /**
         * If the action was performed using the credentials for your Amazon Web Services account, the details of your account.
         */
        var root: UserIdentityRoot?
        /**
         * The type of entity that performed the action.
         */
        var type: UserIdentityType?

        fun build(): UserIdentity
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AssumedRole] inside the given [block]
         */
        fun assumedRole(block: AssumedRole.DslBuilder.() -> kotlin.Unit) {
            this.assumedRole = AssumedRole.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AwsAccount] inside the given [block]
         */
        fun awsAccount(block: AwsAccount.DslBuilder.() -> kotlin.Unit) {
            this.awsAccount = AwsAccount.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AwsService] inside the given [block]
         */
        fun awsService(block: AwsService.DslBuilder.() -> kotlin.Unit) {
            this.awsService = AwsService.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FederatedUser] inside the given [block]
         */
        fun federatedUser(block: FederatedUser.DslBuilder.() -> kotlin.Unit) {
            this.federatedUser = FederatedUser.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IamUser] inside the given [block]
         */
        fun iamUser(block: IamUser.DslBuilder.() -> kotlin.Unit) {
            this.iamUser = IamUser.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserIdentityRoot] inside the given [block]
         */
        fun root(block: UserIdentityRoot.DslBuilder.() -> kotlin.Unit) {
            this.root = UserIdentityRoot.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assumedRole: AssumedRole? = null
        override var awsAccount: AwsAccount? = null
        override var awsService: AwsService? = null
        override var federatedUser: FederatedUser? = null
        override var iamUser: IamUser? = null
        override var root: UserIdentityRoot? = null
        override var type: UserIdentityType? = null

        constructor(x: UserIdentity) : this() {
            this.assumedRole = x.assumedRole
            this.awsAccount = x.awsAccount
            this.awsService = x.awsService
            this.federatedUser = x.federatedUser
            this.iamUser = x.iamUser
            this.root = x.root
            this.type = x.type
        }

        override fun build(): UserIdentity = UserIdentity(this)
        override fun assumedRole(assumedRole: AssumedRole): FluentBuilder = apply { this.assumedRole = assumedRole }
        override fun awsAccount(awsAccount: AwsAccount): FluentBuilder = apply { this.awsAccount = awsAccount }
        override fun awsService(awsService: AwsService): FluentBuilder = apply { this.awsService = awsService }
        override fun federatedUser(federatedUser: FederatedUser): FluentBuilder = apply { this.federatedUser = federatedUser }
        override fun iamUser(iamUser: IamUser): FluentBuilder = apply { this.iamUser = iamUser }
        override fun root(root: UserIdentityRoot): FluentBuilder = apply { this.root = root }
        override fun type(type: UserIdentityType): FluentBuilder = apply { this.type = type }
    }
}
