// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for your Amazon Web Services account.
 */
class UserIdentityRoot private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account.
     */
    val accountId: String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.
     */
    val arn: String? = builder.arn
    /**
     * The unique identifier for the entity that performed the action.
     */
    val principalId: String? = builder.principalId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UserIdentityRoot = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdentityRoot(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UserIdentityRoot

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UserIdentityRoot = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UserIdentityRoot
        /**
         * The unique identifier for the Amazon Web Services account.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The unique identifier for the entity that performed the action.
         */
        fun principalId(principalId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account.
         */
        var accountId: String?
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.
         */
        var arn: String?
        /**
         * The unique identifier for the entity that performed the action.
         */
        var principalId: String?

        fun build(): UserIdentityRoot
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var arn: String? = null
        override var principalId: String? = null

        constructor(x: UserIdentityRoot) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
        }

        override fun build(): UserIdentityRoot = UserIdentityRoot(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
    }
}
