// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about when a classification job was paused. For a one-time job, this object also specifies when the job will expire and be cancelled if it isn't resumed. For a recurring job, this object also specifies when the paused job run will expire and be cancelled if it isn't resumed. This object is present only if a job's current status (jobStatus) is USER_PAUSED. The information in this object applies only to a job that was paused while it had a status of RUNNING.
 */
class UserPausedDetails private constructor(builder: BuilderImpl) {
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.
     */
    val jobExpiresAt: Instant? = builder.jobExpiresAt
    /**
     * The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.
     */
    val jobImminentExpirationHealthEventArn: String? = builder.jobImminentExpirationHealthEventArn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when you paused the job.
     */
    val jobPausedAt: Instant? = builder.jobPausedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UserPausedDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UserPausedDetails(")
        append("jobExpiresAt=$jobExpiresAt,")
        append("jobImminentExpirationHealthEventArn=$jobImminentExpirationHealthEventArn,")
        append("jobPausedAt=$jobPausedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobExpiresAt?.hashCode() ?: 0
        result = 31 * result + (jobImminentExpirationHealthEventArn?.hashCode() ?: 0)
        result = 31 * result + (jobPausedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UserPausedDetails

        if (jobExpiresAt != other.jobExpiresAt) return false
        if (jobImminentExpirationHealthEventArn != other.jobImminentExpirationHealthEventArn) return false
        if (jobPausedAt != other.jobPausedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UserPausedDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UserPausedDetails
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.
         */
        fun jobExpiresAt(jobExpiresAt: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.
         */
        fun jobImminentExpirationHealthEventArn(jobImminentExpirationHealthEventArn: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when you paused the job.
         */
        fun jobPausedAt(jobPausedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.
         */
        var jobExpiresAt: Instant?
        /**
         * The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.
         */
        var jobImminentExpirationHealthEventArn: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when you paused the job.
         */
        var jobPausedAt: Instant?

        fun build(): UserPausedDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var jobExpiresAt: Instant? = null
        override var jobImminentExpirationHealthEventArn: String? = null
        override var jobPausedAt: Instant? = null

        constructor(x: UserPausedDetails) : this() {
            this.jobExpiresAt = x.jobExpiresAt
            this.jobImminentExpirationHealthEventArn = x.jobImminentExpirationHealthEventArn
            this.jobPausedAt = x.jobPausedAt
        }

        override fun build(): UserPausedDetails = UserPausedDetails(this)
        override fun jobExpiresAt(jobExpiresAt: Instant): FluentBuilder = apply { this.jobExpiresAt = jobExpiresAt }
        override fun jobImminentExpirationHealthEventArn(jobImminentExpirationHealthEventArn: String): FluentBuilder = apply { this.jobImminentExpirationHealthEventArn = jobImminentExpirationHealthEventArn }
        override fun jobPausedAt(jobPausedAt: Instant): FluentBuilder = apply { this.jobPausedAt = jobPausedAt }
    }
}
