// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.DeleteFindingsFilterResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteFindingsFilterOperationDeserializer: HttpDeserialize<DeleteFindingsFilterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteFindingsFilterResponse {
        if (!response.status.isSuccess()) {
            throwDeleteFindingsFilterError(context, response)
        }
        val builder = DeleteFindingsFilterResponse.builder()

        return builder.build()
    }
}

private suspend fun throwDeleteFindingsFilterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw Macie2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
