// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.GetFindingStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.GroupCount
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetFindingStatisticsOperationDeserializer: HttpDeserialize<GetFindingStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFindingStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetFindingStatisticsError(context, response)
        }
        val builder = GetFindingStatisticsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFindingStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetFindingStatisticsOperationBody(builder: GetFindingStatisticsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COUNTSBYGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("countsByGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COUNTSBYGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COUNTSBYGROUP_DESCRIPTOR.index -> builder.countsByGroup =
                    deserializer.deserializeList(COUNTSBYGROUP_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupCount>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupCountDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetFindingStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw Macie2Exception(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
