// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An invitation to an AWS account to create a member and join the network.
 *
 * Applies only to Hyperledger Fabric.
 */
class Invitation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the invitation was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The date and time that the invitation expires. This is the `CreationDate` plus the `ProposalDurationInHours` that is specified in the `ProposalThresholdPolicy`. After this date and time, the invitee can no longer create a member and join the network using this `InvitationId`.
     */
    val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The unique identifier for the invitation.
     */
    val invitationId: kotlin.String? = builder.invitationId
    /**
     * A summary of network configuration properties.
     */
    val networkSummary: aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary? = builder.networkSummary
    /**
     * The status of the invitation:
     * + `PENDING` - The invitee has not created a member to join the network, and the invitation has not yet expired.
     * + `ACCEPTING` - The invitee has begun creating a member, and creation has not yet completed.
     * + `ACCEPTED` - The invitee created a member and joined the network using the `InvitationID`.
     * + `REJECTED` - The invitee rejected the invitation.
     * + `EXPIRED` - The invitee neither created a member nor rejected the invitation before the `ExpirationDate`.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.InvitationStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Invitation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Invitation(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("expirationDate=$expirationDate,")
        append("invitationId=$invitationId,")
        append("networkSummary=$networkSummary,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (invitationId?.hashCode() ?: 0)
        result = 31 * result + (networkSummary?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Invitation

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (expirationDate != other.expirationDate) return false
        if (invitationId != other.invitationId) return false
        if (networkSummary != other.networkSummary) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Invitation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time that the invitation was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the invitation expires. This is the `CreationDate` plus the `ProposalDurationInHours` that is specified in the `ProposalThresholdPolicy`. After this date and time, the invitee can no longer create a member and join the network using this `InvitationId`.
         */
        var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the invitation.
         */
        var invitationId: kotlin.String? = null
        /**
         * A summary of network configuration properties.
         */
        var networkSummary: aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary? = null
        /**
         * The status of the invitation:
         * + `PENDING` - The invitee has not created a member to join the network, and the invitation has not yet expired.
         * + `ACCEPTING` - The invitee has begun creating a member, and creation has not yet completed.
         * + `ACCEPTED` - The invitee created a member and joined the network using the `InvitationID`.
         * + `REJECTED` - The invitee rejected the invitation.
         * + `EXPIRED` - The invitee neither created a member nor rejected the invitation before the `ExpirationDate`.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.InvitationStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Invitation) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.expirationDate = x.expirationDate
            this.invitationId = x.invitationId
            this.networkSummary = x.networkSummary
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Invitation = Invitation(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary] inside the given [block]
         */
        fun networkSummary(block: aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary.Builder.() -> kotlin.Unit) {
            this.networkSummary = aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary.invoke(block)
        }
    }
}
