// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



class ListNodesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of nodes to list.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The unique identifier of the member who owns the nodes to list.
     *
     * Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.
     */
    val memberId: kotlin.String? = builder.memberId
    /**
     * The unique identifier of the network for which to list nodes.
     */
    val networkId: kotlin.String? = requireNotNull(builder.networkId) { "A non-null value must be provided for networkId" }
    /**
     * The pagination token that indicates the next set of results to retrieve.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * An optional status specifier. If provided, only nodes currently in this status are listed.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.NodeStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListNodesRequest(")
        append("maxResults=$maxResults,")
        append("memberId=$memberId,")
        append("networkId=$networkId,")
        append("nextToken=$nextToken,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListNodesRequest

        if (maxResults != other.maxResults) return false
        if (memberId != other.memberId) return false
        if (networkId != other.networkId) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of nodes to list.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The unique identifier of the member who owns the nodes to list.
         *
         * Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.
         */
        var memberId: kotlin.String? = null
        /**
         * The unique identifier of the network for which to list nodes.
         */
        var networkId: kotlin.String? = null
        /**
         * The pagination token that indicates the next set of results to retrieve.
         */
        var nextToken: kotlin.String? = null
        /**
         * An optional status specifier. If provided, only nodes currently in this status are listed.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.NodeStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest) : this() {
            this.maxResults = x.maxResults
            this.memberId = x.memberId
            this.networkId = x.networkId
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest = ListNodesRequest(this)
    }
}
