// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of network configuration properties.
 */
class NetworkSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the network was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * An optional description of the network.
     */
    val description: kotlin.String? = builder.description
    /**
     * The blockchain framework that the network uses.
     */
    val framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = builder.framework
    /**
     * The version of the blockchain framework that the network uses.
     */
    val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * The unique identifier of the network.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the network.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current status of the network.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.NetworkStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("framework=$framework,")
        append("frameworkVersion=$frameworkVersion,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (framework != other.framework) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time that the network was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description of the network.
         */
        var description: kotlin.String? = null
        /**
         * The blockchain framework that the network uses.
         */
        var framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = null
        /**
         * The version of the blockchain framework that the network uses.
         */
        var frameworkVersion: kotlin.String? = null
        /**
         * The unique identifier of the network.
         */
        var id: kotlin.String? = null
        /**
         * The name of the network.
         */
        var name: kotlin.String? = null
        /**
         * The current status of the network.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.NetworkStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.framework = x.framework
            this.frameworkVersion = x.frameworkVersion
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.NetworkSummary = NetworkSummary(this)
    }
}
