// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * Configuration properties of a node.
 */
class NodeConfiguration private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the node exists. Required for Ethereum nodes.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The Amazon Managed Blockchain instance type for the node.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.
     */
    val logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration? = builder.logPublishingConfiguration
    /**
     * The state database that the node uses. Values are `LevelDB` or `CouchDB`. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is `CouchDB`.
     *
     * Applies only to Hyperledger Fabric.
     */
    val stateDb: aws.sdk.kotlin.services.managedblockchain.model.StateDbType? = builder.stateDb

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeConfiguration(")
        append("availabilityZone=$availabilityZone,")
        append("instanceType=$instanceType,")
        append("logPublishingConfiguration=$logPublishingConfiguration,")
        append("stateDb=$stateDb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (logPublishingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stateDb?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeConfiguration

        if (availabilityZone != other.availabilityZone) return false
        if (instanceType != other.instanceType) return false
        if (logPublishingConfiguration != other.logPublishingConfiguration) return false
        if (stateDb != other.stateDb) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone in which the node exists. Required for Ethereum nodes.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The Amazon Managed Blockchain instance type for the node.
         */
        var instanceType: kotlin.String? = null
        /**
         * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.
         */
        var logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration? = null
        /**
         * The state database that the node uses. Values are `LevelDB` or `CouchDB`. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is `CouchDB`.
         *
         * Applies only to Hyperledger Fabric.
         */
        var stateDb: aws.sdk.kotlin.services.managedblockchain.model.StateDbType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration) : this() {
            this.availabilityZone = x.availabilityZone
            this.instanceType = x.instanceType
            this.logPublishingConfiguration = x.logPublishingConfiguration
            this.stateDb = x.stateDb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration = NodeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration] inside the given [block]
         */
        fun logPublishingConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration.Builder.() -> kotlin.Unit) {
            this.logPublishingConfiguration = aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration.invoke(block)
        }
    }
}
