// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



class CreateNetworkRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * An optional description for the network.
     */
    val description: kotlin.String? = builder.description
    /**
     * The blockchain framework that the network uses.
     */
    val framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = builder.framework
    /**
     * Configuration properties of the blockchain framework relevant to the network configuration.
     */
    val frameworkConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkConfiguration? = builder.frameworkConfiguration
    /**
     * The version of the blockchain framework that the network uses.
     */
    val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * Configuration properties for the first member within the network.
     */
    val memberConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration? = builder.memberConfiguration
    /**
     * The name of the network.
     */
    val name: kotlin.String? = builder.name
    /**
     * Tags to assign to the network. Each tag consists of a key and optional value.
     *
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The voting rules used by the network to determine if a proposal is approved.
     */
    val votingPolicy: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy? = builder.votingPolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNetworkRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("framework=$framework,")
        append("frameworkConfiguration=$frameworkConfiguration,")
        append("frameworkVersion=$frameworkVersion,")
        append("memberConfiguration=$memberConfiguration,")
        append("name=$name,")
        append("tags=$tags,")
        append("votingPolicy=$votingPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (memberConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (votingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNetworkRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (framework != other.framework) return false
        if (frameworkConfiguration != other.frameworkConfiguration) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (memberConfiguration != other.memberConfiguration) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (votingPolicy != other.votingPolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * An optional description for the network.
         */
        var description: kotlin.String? = null
        /**
         * The blockchain framework that the network uses.
         */
        var framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = null
        /**
         * Configuration properties of the blockchain framework relevant to the network configuration.
         */
        var frameworkConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkConfiguration? = null
        /**
         * The version of the blockchain framework that the network uses.
         */
        var frameworkVersion: kotlin.String? = null
        /**
         * Configuration properties for the first member within the network.
         */
        var memberConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration? = null
        /**
         * The name of the network.
         */
        var name: kotlin.String? = null
        /**
         * Tags to assign to the network. Each tag consists of a key and optional value.
         *
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        var tags: Map<String, String>? = null
        /**
         * The voting rules used by the network to determine if a proposal is approved.
         */
        var votingPolicy: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.framework = x.framework
            this.frameworkConfiguration = x.frameworkConfiguration
            this.frameworkVersion = x.frameworkVersion
            this.memberConfiguration = x.memberConfiguration
            this.name = x.name
            this.tags = x.tags
            this.votingPolicy = x.votingPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest = CreateNetworkRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkConfiguration] inside the given [block]
         */
        fun frameworkConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkConfiguration.Builder.() -> kotlin.Unit) {
            this.frameworkConfiguration = aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration] inside the given [block]
         */
        fun memberConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration.Builder.() -> kotlin.Unit) {
            this.memberConfiguration = aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy] inside the given [block]
         */
        fun votingPolicy(block: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy.Builder.() -> kotlin.Unit) {
            this.votingPolicy = aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy.invoke(block)
        }
    }
}
