// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Network configuration properties.
 */
class Network private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the network was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * Attributes of the blockchain framework for the network.
     */
    val description: kotlin.String? = builder.description
    /**
     * The blockchain framework that the network uses.
     */
    val framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = builder.framework
    /**
     * Attributes of the blockchain framework that the network uses.
     */
    val frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkAttributes? = builder.frameworkAttributes
    /**
     * The version of the blockchain framework that the network uses.
     */
    val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * The unique identifier of the network.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the network.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current status of the network.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.NetworkStatus? = builder.status
    /**
     * Tags assigned to the network. Each tag consists of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The voting rules for the network to decide if a proposal is accepted.
     */
    val votingPolicy: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy? = builder.votingPolicy
    /**
     * The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.
     */
    val vpcEndpointServiceName: kotlin.String? = builder.vpcEndpointServiceName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Network = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Network(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("framework=$framework,")
        append("frameworkAttributes=$frameworkAttributes,")
        append("frameworkVersion=$frameworkVersion,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags,")
        append("votingPolicy=$votingPolicy,")
        append("vpcEndpointServiceName=$vpcEndpointServiceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkAttributes?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (votingPolicy?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Network

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (framework != other.framework) return false
        if (frameworkAttributes != other.frameworkAttributes) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (votingPolicy != other.votingPolicy) return false
        if (vpcEndpointServiceName != other.vpcEndpointServiceName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Network = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time that the network was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Attributes of the blockchain framework for the network.
         */
        var description: kotlin.String? = null
        /**
         * The blockchain framework that the network uses.
         */
        var framework: aws.sdk.kotlin.services.managedblockchain.model.Framework? = null
        /**
         * Attributes of the blockchain framework that the network uses.
         */
        var frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkAttributes? = null
        /**
         * The version of the blockchain framework that the network uses.
         */
        var frameworkVersion: kotlin.String? = null
        /**
         * The unique identifier of the network.
         */
        var id: kotlin.String? = null
        /**
         * The name of the network.
         */
        var name: kotlin.String? = null
        /**
         * The current status of the network.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.NetworkStatus? = null
        /**
         * Tags assigned to the network. Each tag consists of a key and optional value.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        var tags: Map<String, String>? = null
        /**
         * The voting rules for the network to decide if a proposal is accepted.
         */
        var votingPolicy: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy? = null
        /**
         * The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.
         */
        var vpcEndpointServiceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Network) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.framework = x.framework
            this.frameworkAttributes = x.frameworkAttributes
            this.frameworkVersion = x.frameworkVersion
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.votingPolicy = x.votingPolicy
            this.vpcEndpointServiceName = x.vpcEndpointServiceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Network = Network(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkAttributes] inside the given [block]
         */
        fun frameworkAttributes(block: aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkAttributes.Builder.() -> kotlin.Unit) {
            this.frameworkAttributes = aws.sdk.kotlin.services.managedblockchain.model.NetworkFrameworkAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy] inside the given [block]
         */
        fun votingPolicy(block: aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy.Builder.() -> kotlin.Unit) {
            this.votingPolicy = aws.sdk.kotlin.services.managedblockchain.model.VotingPolicy.invoke(block)
        }
    }
}
