// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Configuration properties of a node.
 */
class Node private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The Availability Zone in which the node exists. Required for Ethereum nodes.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The date and time that the node was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * Attributes of the blockchain framework being used.
     */
    val frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.NodeFrameworkAttributes? = builder.frameworkAttributes
    /**
     * The unique identifier of the node.
     */
    val id: kotlin.String? = builder.id
    /**
     * The instance type of the node.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the node uses for encryption at rest. If the value of this parameter is `"AWS Owned KMS Key"`, the node uses an AWS owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.
     *
     * Applies only to Hyperledger Fabric.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.
     */
    val logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration? = builder.logPublishingConfiguration
    /**
     * The unique identifier of the member to which the node belongs.
     *
     * Applies only to Hyperledger Fabric.
     */
    val memberId: kotlin.String? = builder.memberId
    /**
     * The unique identifier of the network that the node is on.
     */
    val networkId: kotlin.String? = builder.networkId
    /**
     * The state database that the node uses. Values are `LevelDB` or `CouchDB`.
     *
     * Applies only to Hyperledger Fabric.
     */
    val stateDb: aws.sdk.kotlin.services.managedblockchain.model.StateDbType? = builder.stateDb
    /**
     * The status of the node.
     * + `CREATING` - The AWS account is in the process of creating a node.
     * + `AVAILABLE` - The node has been created and can participate in the network.
     * + `UNHEALTHY` - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to `AVAILABLE`. Otherwise, it moves to `FAILED` status.
     * + `CREATE_FAILED` - The AWS account attempted to create a node and creation failed.
     * + `UPDATING` - The node is in the process of being updated.
     * + `DELETING` - The node is in the process of being deleted.
     * + `DELETED` - The node can no longer participate on the network.
     * + `FAILED` - The node is no longer functional, cannot be recovered, and must be deleted.
     * + `INACCESSIBLE_ENCRYPTION_KEY` - The node is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key, or revoking a grant is not immediate. The node resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.NodeStatus? = builder.status
    /**
     * Tags assigned to the node. Each tag consists of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Node = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Node(")
        append("arn=$arn,")
        append("availabilityZone=$availabilityZone,")
        append("creationDate=$creationDate,")
        append("frameworkAttributes=$frameworkAttributes,")
        append("id=$id,")
        append("instanceType=$instanceType,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("logPublishingConfiguration=$logPublishingConfiguration,")
        append("memberId=$memberId,")
        append("networkId=$networkId,")
        append("stateDb=$stateDb,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (frameworkAttributes?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (logPublishingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (stateDb?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Node

        if (arn != other.arn) return false
        if (availabilityZone != other.availabilityZone) return false
        if (creationDate != other.creationDate) return false
        if (frameworkAttributes != other.frameworkAttributes) return false
        if (id != other.id) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (logPublishingConfiguration != other.logPublishingConfiguration) return false
        if (memberId != other.memberId) return false
        if (networkId != other.networkId) return false
        if (stateDb != other.stateDb) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Node = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The Availability Zone in which the node exists. Required for Ethereum nodes.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The date and time that the node was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Attributes of the blockchain framework being used.
         */
        var frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.NodeFrameworkAttributes? = null
        /**
         * The unique identifier of the node.
         */
        var id: kotlin.String? = null
        /**
         * The instance type of the node.
         */
        var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the node uses for encryption at rest. If the value of this parameter is `"AWS Owned KMS Key"`, the node uses an AWS owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.
         *
         * Applies only to Hyperledger Fabric.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.
         */
        var logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration? = null
        /**
         * The unique identifier of the member to which the node belongs.
         *
         * Applies only to Hyperledger Fabric.
         */
        var memberId: kotlin.String? = null
        /**
         * The unique identifier of the network that the node is on.
         */
        var networkId: kotlin.String? = null
        /**
         * The state database that the node uses. Values are `LevelDB` or `CouchDB`.
         *
         * Applies only to Hyperledger Fabric.
         */
        var stateDb: aws.sdk.kotlin.services.managedblockchain.model.StateDbType? = null
        /**
         * The status of the node.
         * + `CREATING` - The AWS account is in the process of creating a node.
         * + `AVAILABLE` - The node has been created and can participate in the network.
         * + `UNHEALTHY` - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to `AVAILABLE`. Otherwise, it moves to `FAILED` status.
         * + `CREATE_FAILED` - The AWS account attempted to create a node and creation failed.
         * + `UPDATING` - The node is in the process of being updated.
         * + `DELETING` - The node is in the process of being deleted.
         * + `DELETED` - The node can no longer participate on the network.
         * + `FAILED` - The node is no longer functional, cannot be recovered, and must be deleted.
         * + `INACCESSIBLE_ENCRYPTION_KEY` - The node is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key, or revoking a grant is not immediate. The node resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.NodeStatus? = null
        /**
         * Tags assigned to the node. Each tag consists of a key and optional value.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Node) : this() {
            this.arn = x.arn
            this.availabilityZone = x.availabilityZone
            this.creationDate = x.creationDate
            this.frameworkAttributes = x.frameworkAttributes
            this.id = x.id
            this.instanceType = x.instanceType
            this.kmsKeyArn = x.kmsKeyArn
            this.logPublishingConfiguration = x.logPublishingConfiguration
            this.memberId = x.memberId
            this.networkId = x.networkId
            this.stateDb = x.stateDb
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Node = Node(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NodeFrameworkAttributes] inside the given [block]
         */
        fun frameworkAttributes(block: aws.sdk.kotlin.services.managedblockchain.model.NodeFrameworkAttributes.Builder.() -> kotlin.Unit) {
            this.frameworkAttributes = aws.sdk.kotlin.services.managedblockchain.model.NodeFrameworkAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration] inside the given [block]
         */
        fun logPublishingConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration.Builder.() -> kotlin.Unit) {
            this.logPublishingConfiguration = aws.sdk.kotlin.services.managedblockchain.model.NodeLogPublishingConfiguration.invoke(block)
        }
    }
}
