// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties of a proposal on a Managed Blockchain network.
 *
 * Applies only to Hyperledger Fabric.
 */
class Proposal private constructor(builder: Builder) {
    /**
     * The actions to perform on the network if the proposal is `APPROVED`.
     */
    val actions: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions? = builder.actions
    /**
     * The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the proposal was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The description of the proposal.
     */
    val description: kotlin.String? = builder.description
    /**
     * The date and time that the proposal expires. This is the `CreationDate` plus the `ProposalDurationInHours` that is specified in the `ProposalThresholdPolicy`. After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is `EXPIRED` and `Actions` are not carried out.
     */
    val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The unique identifier of the network for which the proposal is made.
     */
    val networkId: kotlin.String? = builder.networkId
    /**
     * The current total of `NO` votes cast on the proposal by members.
     */
    val noVoteCount: kotlin.Int? = builder.noVoteCount
    /**
     * The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of `YES` votes and `NO` votes.
     */
    val outstandingVoteCount: kotlin.Int? = builder.outstandingVoteCount
    /**
     * The unique identifier of the proposal.
     */
    val proposalId: kotlin.String? = builder.proposalId
    /**
     * The unique identifier of the member that created the proposal.
     */
    val proposedByMemberId: kotlin.String? = builder.proposedByMemberId
    /**
     * The name of the member that created the proposal.
     */
    val proposedByMemberName: kotlin.String? = builder.proposedByMemberName
    /**
     * The status of the proposal. Values are as follows:
     * + `IN_PROGRESS` - The proposal is active and open for member voting.
     * + `APPROVED` - The proposal was approved with sufficient `YES` votes among members according to the `VotingPolicy` specified for the `Network`. The specified proposal actions are carried out.
     * + `REJECTED` - The proposal was rejected with insufficient `YES` votes among members according to the `VotingPolicy` specified for the `Network`. The specified `ProposalActions` are not carried out.
     * + `EXPIRED` - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified `ProposalActions` are not carried out.
     * + `ACTION_FAILED` - One or more of the specified `ProposalActions` in a proposal that was approved could not be completed because of an error. The `ACTION_FAILED` status occurs even if only one ProposalAction fails and other actions are successful.
     */
    val status: aws.sdk.kotlin.services.managedblockchain.model.ProposalStatus? = builder.status
    /**
     * Tags assigned to the proposal. Each tag consists of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The current total of `YES` votes cast on the proposal by members.
     */
    val yesVoteCount: kotlin.Int? = builder.yesVoteCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Proposal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Proposal(")
        append("actions=$actions,")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("networkId=$networkId,")
        append("noVoteCount=$noVoteCount,")
        append("outstandingVoteCount=$outstandingVoteCount,")
        append("proposalId=$proposalId,")
        append("proposedByMemberId=$proposedByMemberId,")
        append("proposedByMemberName=$proposedByMemberName,")
        append("status=$status,")
        append("tags=$tags,")
        append("yesVoteCount=$yesVoteCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (noVoteCount ?: 0)
        result = 31 * result + (outstandingVoteCount ?: 0)
        result = 31 * result + (proposalId?.hashCode() ?: 0)
        result = 31 * result + (proposedByMemberId?.hashCode() ?: 0)
        result = 31 * result + (proposedByMemberName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (yesVoteCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Proposal

        if (actions != other.actions) return false
        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (networkId != other.networkId) return false
        if (noVoteCount != other.noVoteCount) return false
        if (outstandingVoteCount != other.outstandingVoteCount) return false
        if (proposalId != other.proposalId) return false
        if (proposedByMemberId != other.proposedByMemberId) return false
        if (proposedByMemberName != other.proposedByMemberName) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (yesVoteCount != other.yesVoteCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Proposal = Builder(this).apply(block).build()

    class Builder {
        /**
         * The actions to perform on the network if the proposal is `APPROVED`.
         */
        var actions: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions? = null
        /**
         * The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time that the proposal was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the proposal.
         */
        var description: kotlin.String? = null
        /**
         * The date and time that the proposal expires. This is the `CreationDate` plus the `ProposalDurationInHours` that is specified in the `ProposalThresholdPolicy`. After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is `EXPIRED` and `Actions` are not carried out.
         */
        var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the network for which the proposal is made.
         */
        var networkId: kotlin.String? = null
        /**
         * The current total of `NO` votes cast on the proposal by members.
         */
        var noVoteCount: kotlin.Int? = null
        /**
         * The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of `YES` votes and `NO` votes.
         */
        var outstandingVoteCount: kotlin.Int? = null
        /**
         * The unique identifier of the proposal.
         */
        var proposalId: kotlin.String? = null
        /**
         * The unique identifier of the member that created the proposal.
         */
        var proposedByMemberId: kotlin.String? = null
        /**
         * The name of the member that created the proposal.
         */
        var proposedByMemberName: kotlin.String? = null
        /**
         * The status of the proposal. Values are as follows:
         * + `IN_PROGRESS` - The proposal is active and open for member voting.
         * + `APPROVED` - The proposal was approved with sufficient `YES` votes among members according to the `VotingPolicy` specified for the `Network`. The specified proposal actions are carried out.
         * + `REJECTED` - The proposal was rejected with insufficient `YES` votes among members according to the `VotingPolicy` specified for the `Network`. The specified `ProposalActions` are not carried out.
         * + `EXPIRED` - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified `ProposalActions` are not carried out.
         * + `ACTION_FAILED` - One or more of the specified `ProposalActions` in a proposal that was approved could not be completed because of an error. The `ACTION_FAILED` status occurs even if only one ProposalAction fails and other actions are successful.
         */
        var status: aws.sdk.kotlin.services.managedblockchain.model.ProposalStatus? = null
        /**
         * Tags assigned to the proposal. Each tag consists of a key and optional value.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        var tags: Map<String, String>? = null
        /**
         * The current total of `YES` votes cast on the proposal by members.
         */
        var yesVoteCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Proposal) : this() {
            this.actions = x.actions
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.networkId = x.networkId
            this.noVoteCount = x.noVoteCount
            this.outstandingVoteCount = x.outstandingVoteCount
            this.proposalId = x.proposalId
            this.proposedByMemberId = x.proposedByMemberId
            this.proposedByMemberName = x.proposedByMemberName
            this.status = x.status
            this.tags = x.tags
            this.yesVoteCount = x.yesVoteCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Proposal = Proposal(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.ProposalActions] inside the given [block]
         */
        fun actions(block: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions.Builder.() -> kotlin.Unit) {
            this.actions = aws.sdk.kotlin.services.managedblockchain.model.ProposalActions.invoke(block)
        }
    }
}
