// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.managedblockchain.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.managedblockchain.model.*
import aws.sdk.kotlin.services.managedblockchain.model.CreateMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateProposalResponse
import aws.sdk.kotlin.services.managedblockchain.model.DeleteMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.DeleteMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.DeleteNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.DeleteNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetNetworkRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetNetworkResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetProposalResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.RejectInvitationRequest
import aws.sdk.kotlin.services.managedblockchain.model.RejectInvitationResponse
import aws.sdk.kotlin.services.managedblockchain.model.TagResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.TagResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.UntagResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.UntagResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.UpdateMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.UpdateMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.UpdateNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.UpdateNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.VoteOnProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.VoteOnProposalResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Managed Blockchain is a fully managed service for creating and managing blockchain networks using open-source frameworks. Blockchain allows you to build applications where multiple parties can securely and transparently run transactions and share data without the need for a trusted, central authority.
 *
 * Managed Blockchain supports the Hyperledger Fabric and Ethereum open-source frameworks. Because of fundamental differences between the frameworks, some API actions or data types may only apply in the context of one framework and not the other. For example, actions related to Hyperledger Fabric network members such as `CreateMember` and `DeleteMember` do not apply to Ethereum.
 *
 * The description for each action indicates the framework or frameworks to which it applies. Data types and properties that apply only in the context of a particular framework are similarly indicated.
 */
public interface ManagedBlockchainClient : SdkClient {

    override val serviceName: String
        get() = "ManagedBlockchain"
    /**
     * ManagedBlockchainClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ManagedBlockchainClient {
            val config = Config.Builder().apply(block).build()
            return DefaultManagedBlockchainClient(config)
        }

        public operator fun invoke(config: Config): ManagedBlockchainClient = DefaultManagedBlockchainClient(config)

        /**
         * Construct a [ManagedBlockchainClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ManagedBlockchainClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultManagedBlockchainClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a member within a Managed Blockchain network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse

    /**
     * Creates a new blockchain network using Amazon Managed Blockchain.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createNetwork(input: CreateNetworkRequest): CreateNetworkResponse

    /**
     * Creates a node on the specified blockchain network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun createNode(input: CreateNodeRequest): CreateNodeResponse

    /**
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createProposal(input: CreateProposalRequest): CreateProposalResponse

    /**
     * Deletes a member. Deleting a member removes the member and all associated resources from the network. `DeleteMember` can only be called for a specified `MemberId` if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the `DeleteMember` action is carried out as the result of an approved proposal to remove a member. If `MemberId` is the last member in a network specified by the last AWS account, the network is deleted also.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse

    /**
     * Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun deleteNode(input: DeleteNodeRequest): DeleteNodeResponse

    /**
     * Returns detailed information about a member.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Returns detailed information about a network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun getNetwork(input: GetNetworkRequest): GetNetworkResponse

    /**
     * Returns detailed information about a node.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun getNode(input: GetNodeRequest): GetNodeResponse

    /**
     * Returns detailed information about a proposal.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun getProposal(input: GetProposalRequest): GetProposalResponse

    /**
     * Returns a list of all invitations for the current AWS account.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest {}): ListInvitationsResponse

    /**
     * Returns a list of the members in a network and properties of their configurations.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listMembers(input: ListMembersRequest): ListMembersResponse

    /**
     * Returns information about the networks in which the current AWS account participates.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun listNetworks(input: ListNetworksRequest = ListNetworksRequest {}): ListNetworksResponse

    /**
     * Returns information about the nodes within a network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listProposalVotes(input: ListProposalVotesRequest): ListProposalVotesResponse

    /**
     * Returns a list of proposals for the network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listProposals(input: ListProposalsRequest): ListProposalsResponse

    /**
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse

    /**
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.
     *
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use `UntagResource` to remove tag keys.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a member configuration with new parameters.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun updateMember(input: UpdateMemberRequest): UpdateMemberResponse

    /**
     * Updates a node configuration with new parameters.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun updateNode(input: UpdateNodeRequest): UpdateNodeResponse

    /**
     * Casts a vote for a specified `ProposalId` on behalf of a member. The member to vote as, specified by `VoterMemberId`, must be in the same AWS account as the principal that calls the action.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun voteOnProposal(input: VoteOnProposalRequest): VoteOnProposalResponse
}

/**
 * Creates a member within a Managed Blockchain network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createMember(crossinline block: CreateMemberRequest.Builder.() -> Unit): CreateMemberResponse = createMember(CreateMemberRequest.Builder().apply(block).build())

/**
 * Creates a new blockchain network using Amazon Managed Blockchain.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createNetwork(crossinline block: CreateNetworkRequest.Builder.() -> Unit): CreateNetworkResponse = createNetwork(CreateNetworkRequest.Builder().apply(block).build())

/**
 * Creates a node on the specified blockchain network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.createNode(crossinline block: CreateNodeRequest.Builder.() -> Unit): CreateNodeResponse = createNode(CreateNodeRequest.Builder().apply(block).build())

/**
 * Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createProposal(crossinline block: CreateProposalRequest.Builder.() -> Unit): CreateProposalResponse = createProposal(CreateProposalRequest.Builder().apply(block).build())

/**
 * Deletes a member. Deleting a member removes the member and all associated resources from the network. `DeleteMember` can only be called for a specified `MemberId` if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the `DeleteMember` action is carried out as the result of an approved proposal to remove a member. If `MemberId` is the last member in a network specified by the last AWS account, the network is deleted also.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.deleteMember(crossinline block: DeleteMemberRequest.Builder.() -> Unit): DeleteMemberResponse = deleteMember(DeleteMemberRequest.Builder().apply(block).build())

/**
 * Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.deleteNode(crossinline block: DeleteNodeRequest.Builder.() -> Unit): DeleteNodeResponse = deleteNode(DeleteNodeRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a member.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.getMember(crossinline block: GetMemberRequest.Builder.() -> Unit): GetMemberResponse = getMember(GetMemberRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.getNetwork(crossinline block: GetNetworkRequest.Builder.() -> Unit): GetNetworkResponse = getNetwork(GetNetworkRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a node.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.getNode(crossinline block: GetNodeRequest.Builder.() -> Unit): GetNodeResponse = getNode(GetNodeRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a proposal.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.getProposal(crossinline block: GetProposalRequest.Builder.() -> Unit): GetProposalResponse = getProposal(GetProposalRequest.Builder().apply(block).build())

/**
 * Returns a list of all invitations for the current AWS account.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listInvitations(crossinline block: ListInvitationsRequest.Builder.() -> Unit): ListInvitationsResponse = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Returns a list of the members in a network and properties of their configurations.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Returns information about the networks in which the current AWS account participates.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.listNetworks(crossinline block: ListNetworksRequest.Builder.() -> Unit): ListNetworksResponse = listNetworks(ListNetworksRequest.Builder().apply(block).build())

/**
 * Returns information about the nodes within a network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listProposalVotes(crossinline block: ListProposalVotesRequest.Builder.() -> Unit): ListProposalVotesResponse = listProposalVotes(ListProposalVotesRequest.Builder().apply(block).build())

/**
 * Returns a list of proposals for the network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listProposals(crossinline block: ListProposalsRequest.Builder.() -> Unit): ListProposalsResponse = listProposals(ListProposalsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.rejectInvitation(crossinline block: RejectInvitationRequest.Builder.() -> Unit): RejectInvitationResponse = rejectInvitation(RejectInvitationRequest.Builder().apply(block).build())

/**
 * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.
 *
 * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use `UntagResource` to remove tag keys.
 *
 * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the Amazon Managed Blockchain resource.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a member configuration with new parameters.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.updateMember(crossinline block: UpdateMemberRequest.Builder.() -> Unit): UpdateMemberResponse = updateMember(UpdateMemberRequest.Builder().apply(block).build())

/**
 * Updates a node configuration with new parameters.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.updateNode(crossinline block: UpdateNodeRequest.Builder.() -> Unit): UpdateNodeResponse = updateNode(UpdateNodeRequest.Builder().apply(block).build())

/**
 * Casts a vote for a specified `ProposalId` on behalf of a member. The member to vote as, specified by `VoterMemberId`, must be in the same AWS account as the principal that calls the action.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.voteOnProposal(crossinline block: VoteOnProposalRequest.Builder.() -> Unit): VoteOnProposalResponse = voteOnProposal(VoteOnProposalRequest.Builder().apply(block).build())
