// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * Configuration properties for logging events associated with a peer node owned by a member in a Managed Blockchain network.
 */
public class NodeFabricLogPublishingConfiguration private constructor(builder: Builder) {
    /**
     * Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.
     */
    public val chaincodeLogs: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations? = builder.chaincodeLogs
    /**
     * Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node.
     */
    public val peerLogs: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations? = builder.peerLogs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.NodeFabricLogPublishingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeFabricLogPublishingConfiguration(")
        append("chaincodeLogs=$chaincodeLogs,")
        append("peerLogs=$peerLogs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = chaincodeLogs?.hashCode() ?: 0
        result = 31 * result + (peerLogs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeFabricLogPublishingConfiguration

        if (chaincodeLogs != other.chaincodeLogs) return false
        if (peerLogs != other.peerLogs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.NodeFabricLogPublishingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.
         */
        public var chaincodeLogs: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations? = null
        /**
         * Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node.
         */
        public var peerLogs: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.NodeFabricLogPublishingConfiguration) : this() {
            this.chaincodeLogs = x.chaincodeLogs
            this.peerLogs = x.peerLogs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.NodeFabricLogPublishingConfiguration = NodeFabricLogPublishingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations] inside the given [block]
         */
        public fun chaincodeLogs(block: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations.Builder.() -> kotlin.Unit) {
            this.chaincodeLogs = aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations] inside the given [block]
         */
        public fun peerLogs(block: aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations.Builder.() -> kotlin.Unit) {
            this.peerLogs = aws.sdk.kotlin.services.managedblockchain.model.LogConfigurations.invoke(block)
        }
    }
}
