// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.managedblockchain.model.*
import aws.sdk.kotlin.services.managedblockchain.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "ManagedBlockchain"
const val ServiceApiVersion: String = "2018-09-24"
const val SdkVersion: String = "0.14.4-beta"

internal class DefaultManagedBlockchainClient(override val config: ManagedBlockchainClient.Config) : ManagedBlockchainClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a member within a Managed Blockchain network.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse {
        val op = SdkHttpOperation.build<CreateMemberRequest, CreateMemberResponse> {
            serializer = CreateMemberOperationSerializer()
            deserializer = CreateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new blockchain network using Amazon Managed Blockchain.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun createNetwork(input: CreateNetworkRequest): CreateNetworkResponse {
        val op = SdkHttpOperation.build<CreateNetworkRequest, CreateNetworkResponse> {
            serializer = CreateNetworkOperationSerializer()
            deserializer = CreateNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetwork"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a node on the specified blockchain network.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun createNode(input: CreateNodeRequest): CreateNodeResponse {
        val op = SdkHttpOperation.build<CreateNodeRequest, CreateNodeResponse> {
            serializer = CreateNodeOperationSerializer()
            deserializer = CreateNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun createProposal(input: CreateProposalRequest): CreateProposalResponse {
        val op = SdkHttpOperation.build<CreateProposalRequest, CreateProposalResponse> {
            serializer = CreateProposalOperationSerializer()
            deserializer = CreateProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProposal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a member. Deleting a member removes the member and all associated resources from the network. DeleteMember can only be called for a specified MemberId if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the DeleteMember action is carried out as the result of an approved proposal to remove a member. If MemberId is the last member in a network specified by the last AWS account, the network is deleted also.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse {
        val op = SdkHttpOperation.build<DeleteMemberRequest, DeleteMemberResponse> {
            serializer = DeleteMemberOperationSerializer()
            deserializer = DeleteMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun deleteNode(input: DeleteNodeRequest): DeleteNodeResponse {
        val op = SdkHttpOperation.build<DeleteNodeRequest, DeleteNodeResponse> {
            serializer = DeleteNodeOperationSerializer()
            deserializer = DeleteNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about a member.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun getMember(input: GetMemberRequest): GetMemberResponse {
        val op = SdkHttpOperation.build<GetMemberRequest, GetMemberResponse> {
            serializer = GetMemberOperationSerializer()
            deserializer = GetMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about a network.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun getNetwork(input: GetNetworkRequest): GetNetworkResponse {
        val op = SdkHttpOperation.build<GetNetworkRequest, GetNetworkResponse> {
            serializer = GetNetworkOperationSerializer()
            deserializer = GetNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetwork"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about a node.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun getNode(input: GetNodeRequest): GetNodeResponse {
        val op = SdkHttpOperation.build<GetNodeRequest, GetNodeResponse> {
            serializer = GetNodeOperationSerializer()
            deserializer = GetNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about a proposal.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun getProposal(input: GetProposalRequest): GetProposalResponse {
        val op = SdkHttpOperation.build<GetProposalRequest, GetProposalResponse> {
            serializer = GetProposalOperationSerializer()
            deserializer = GetProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProposal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all invitations for the current AWS account.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse {
        val op = SdkHttpOperation.build<ListInvitationsRequest, ListInvitationsResponse> {
            serializer = ListInvitationsOperationSerializer()
            deserializer = ListInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the members in a network and properties of their configurations.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the networks in which the current AWS account participates.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun listNetworks(input: ListNetworksRequest): ListNetworksResponse {
        val op = SdkHttpOperation.build<ListNetworksRequest, ListNetworksResponse> {
            serializer = ListNetworksOperationSerializer()
            deserializer = ListNetworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNetworks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the nodes within a network.
     * Applies to Hyperledger Fabric and Ethereum.
     */
    override suspend fun listNodes(input: ListNodesRequest): ListNodesResponse {
        val op = SdkHttpOperation.build<ListNodesRequest, ListNodesResponse> {
            serializer = ListNodesOperationSerializer()
            deserializer = ListNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun listProposalVotes(input: ListProposalVotesRequest): ListProposalVotesResponse {
        val op = SdkHttpOperation.build<ListProposalVotesRequest, ListProposalVotesResponse> {
            serializer = ListProposalVotesOperationSerializer()
            deserializer = ListProposalVotesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProposalVotes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of proposals for the network.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun listProposals(input: ListProposalsRequest): ListProposalsResponse {
        val op = SdkHttpOperation.build<ListProposalsRequest, ListProposalsResponse> {
            serializer = ListProposalsOperationSerializer()
            deserializer = ListProposalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProposals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse {
        val op = SdkHttpOperation.build<RejectInvitationRequest, RejectInvitationResponse> {
            serializer = RejectInvitationOperationSerializer()
            deserializer = RejectInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use UntagResource to remove tag keys.
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a member configuration with new parameters.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun updateMember(input: UpdateMemberRequest): UpdateMemberResponse {
        val op = SdkHttpOperation.build<UpdateMemberRequest, UpdateMemberResponse> {
            serializer = UpdateMemberOperationSerializer()
            deserializer = UpdateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a node configuration with new parameters.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun updateNode(input: UpdateNodeRequest): UpdateNodeResponse {
        val op = SdkHttpOperation.build<UpdateNodeRequest, UpdateNodeResponse> {
            serializer = UpdateNodeOperationSerializer()
            deserializer = UpdateNodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Casts a vote for a specified ProposalId on behalf of a member. The member to vote as, specified by VoterMemberId, must be in the same AWS account as the principal that calls the action.
     * Applies only to Hyperledger Fabric.
     */
    override suspend fun voteOnProposal(input: VoteOnProposalRequest): VoteOnProposalResponse {
        val op = SdkHttpOperation.build<VoteOnProposalRequest, VoteOnProposalResponse> {
            serializer = VoteOnProposalOperationSerializer()
            deserializer = VoteOnProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "VoteOnProposal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "managedblockchain"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AuthAttributes.SigningService, "managedblockchain")
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AuthAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
