// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * A policy type that defines the voting rules for the network. The rules decide if a proposal is approved. Approval may be based on criteria such as the percentage of YES votes and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.
 * Applies only to Hyperledger Fabric.
 */
class ApprovalThresholdPolicy private constructor(builder: Builder) {
    /**
     * The duration from the time that a proposal is created until it expires. If members cast neither the required number of YES votes to approve the proposal nor the number of NO votes required to reject it before the duration expires, the proposal is EXPIRED and ProposalActions are not carried out.
     */
    val proposalDurationInHours: kotlin.Int? = builder.proposalDurationInHours
    /**
     * Determines whether the vote percentage must be greater than the ThresholdPercentage or must be greater than or equal to the ThreholdPercentage to be approved.
     */
    val thresholdComparator: aws.sdk.kotlin.services.managedblockchain.model.ThresholdComparator? = builder.thresholdComparator
    /**
     * The percentage of votes among all members that must be YES for a proposal to be approved. For example, a ThresholdPercentage value of 50 indicates 50%. The ThresholdComparator determines the precise comparison. If a ThresholdPercentage value of 50 is specified on a network with 10 members, along with a ThresholdComparator value of GREATER_THAN, this indicates that 6 YES votes are required for the proposal to be approved.
     */
    val thresholdPercentage: kotlin.Int? = builder.thresholdPercentage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.ApprovalThresholdPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApprovalThresholdPolicy(")
        append("proposalDurationInHours=$proposalDurationInHours,")
        append("thresholdComparator=$thresholdComparator,")
        append("thresholdPercentage=$thresholdPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = proposalDurationInHours ?: 0
        result = 31 * result + (thresholdComparator?.hashCode() ?: 0)
        result = 31 * result + (thresholdPercentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApprovalThresholdPolicy

        if (proposalDurationInHours != other.proposalDurationInHours) return false
        if (thresholdComparator != other.thresholdComparator) return false
        if (thresholdPercentage != other.thresholdPercentage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.ApprovalThresholdPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * The duration from the time that a proposal is created until it expires. If members cast neither the required number of YES votes to approve the proposal nor the number of NO votes required to reject it before the duration expires, the proposal is EXPIRED and ProposalActions are not carried out.
         */
        var proposalDurationInHours: kotlin.Int? = null
        /**
         * Determines whether the vote percentage must be greater than the ThresholdPercentage or must be greater than or equal to the ThreholdPercentage to be approved.
         */
        var thresholdComparator: aws.sdk.kotlin.services.managedblockchain.model.ThresholdComparator? = null
        /**
         * The percentage of votes among all members that must be YES for a proposal to be approved. For example, a ThresholdPercentage value of 50 indicates 50%. The ThresholdComparator determines the precise comparison. If a ThresholdPercentage value of 50 is specified on a network with 10 members, along with a ThresholdComparator value of GREATER_THAN, this indicates that 6 YES votes are required for the proposal to be approved.
         */
        var thresholdPercentage: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.ApprovalThresholdPolicy) : this() {
            this.proposalDurationInHours = x.proposalDurationInHours
            this.thresholdComparator = x.thresholdComparator
            this.thresholdPercentage = x.thresholdPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.ApprovalThresholdPolicy = ApprovalThresholdPolicy(this)
    }
}
