// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * Attributes of an Ethereum node.
 */
class NodeEthereumAttributes private constructor(builder: Builder) {
    /**
     * The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    val httpEndpoint: kotlin.String? = builder.httpEndpoint
    /**
     * The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSockets connections from a client. Use this endpoint in client code for smart contracts when using a WebSockets connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
     */
    val webSocketEndpoint: kotlin.String? = builder.webSocketEndpoint

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.NodeEthereumAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeEthereumAttributes(")
        append("httpEndpoint=$httpEndpoint,")
        append("webSocketEndpoint=$webSocketEndpoint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpEndpoint?.hashCode() ?: 0
        result = 31 * result + (webSocketEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeEthereumAttributes

        if (httpEndpoint != other.httpEndpoint) return false
        if (webSocketEndpoint != other.webSocketEndpoint) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.NodeEthereumAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
         */
        var httpEndpoint: kotlin.String? = null
        /**
         * The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSockets connections from a client. Use this endpoint in client code for smart contracts when using a WebSockets connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4.
         */
        var webSocketEndpoint: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.NodeEthereumAttributes) : this() {
            this.httpEndpoint = x.httpEndpoint
            this.webSocketEndpoint = x.webSocketEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.NodeEthereumAttributes = NodeEthereumAttributes(this)
    }
}
