// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacecommerceanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for the parameters to the StartSupportDataExport operation.
 */
public class StartSupportDataExportRequest private constructor(builder: Builder) {
    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the data set metadata file.
     */
    public val customerDefinedValues: Map<String, String>? = builder.customerDefinedValues
    /**
     * Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code, Operation Type, and Operation Time.
     *
     * + *customer_support_contacts_data* Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter.
     * + *test_customer_support_contacts_data* An example data set containing static test data in the same format as customer_support_contacts_data
     */
    public val dataSetType: aws.sdk.kotlin.services.marketplacecommerceanalytics.model.SupportDataSetType? = builder.dataSetType
    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     */
    public val destinationS3BucketName: kotlin.String? = builder.destinationS3BucketName
    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3 bucket root.
     */
    public val destinationS3Prefix: kotlin.String? = builder.destinationS3Prefix
    /**
     * The start date from which to retrieve the data set in UTC. This parameter only affects the customer_support_contacts_data data set type.
     */
    public val fromDate: aws.smithy.kotlin.runtime.time.Instant? = builder.fromDate
    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS services.
     */
    public val roleNameArn: kotlin.String? = builder.roleNameArn
    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an error has occurred.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSupportDataExportRequest(")
        append("customerDefinedValues=$customerDefinedValues,")
        append("dataSetType=$dataSetType,")
        append("destinationS3BucketName=$destinationS3BucketName,")
        append("destinationS3Prefix=$destinationS3Prefix,")
        append("fromDate=$fromDate,")
        append("roleNameArn=$roleNameArn,")
        append("snsTopicArn=$snsTopicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerDefinedValues?.hashCode() ?: 0
        result = 31 * result + (dataSetType?.hashCode() ?: 0)
        result = 31 * result + (destinationS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (destinationS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (fromDate?.hashCode() ?: 0)
        result = 31 * result + (roleNameArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSupportDataExportRequest

        if (customerDefinedValues != other.customerDefinedValues) return false
        if (dataSetType != other.dataSetType) return false
        if (destinationS3BucketName != other.destinationS3BucketName) return false
        if (destinationS3Prefix != other.destinationS3Prefix) return false
        if (fromDate != other.fromDate) return false
        if (roleNameArn != other.roleNameArn) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the data set metadata file.
         */
        public var customerDefinedValues: Map<String, String>? = null
        /**
         * Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code, Operation Type, and Operation Time.
         *
         * + *customer_support_contacts_data* Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter.
         * + *test_customer_support_contacts_data* An example data set containing static test data in the same format as customer_support_contacts_data
         */
        public var dataSetType: aws.sdk.kotlin.services.marketplacecommerceanalytics.model.SupportDataSetType? = null
        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         */
        public var destinationS3BucketName: kotlin.String? = null
        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3 bucket root.
         */
        public var destinationS3Prefix: kotlin.String? = null
        /**
         * The start date from which to retrieve the data set in UTC. This parameter only affects the customer_support_contacts_data data set type.
         */
        public var fromDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS services.
         */
        public var roleNameArn: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an error has occurred.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest) : this() {
            this.customerDefinedValues = x.customerDefinedValues
            this.dataSetType = x.dataSetType
            this.destinationS3BucketName = x.destinationS3BucketName
            this.destinationS3Prefix = x.destinationS3Prefix
            this.fromDate = x.fromDate
            this.roleNameArn = x.roleNameArn
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest = StartSupportDataExportRequest(this)
    }
}
