// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.time.Instant

class MeterUsageRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the permissions required for the action, but does not make the request. If you have the permissions, the request returns `DryRunOperation`; otherwise, it returns `UnauthorizedException`. Defaults to `false` if not specified.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as the one used during the publishing of a new product.
     */
    val productCode: kotlin.String? = builder.productCode
    /**
     * Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one hour in the past. Make sure the `timestamp` value is not before the start of the software usage.
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The set of `UsageAllocations` to submit.
     *
     * The sum of all `UsageAllocation` quantities must equal the `UsageQuantity` of the `MeterUsage` request, and each `UsageAllocation` must have a unique set of tags (include no tags).
     */
    val usageAllocations: List<UsageAllocation>? = builder.usageAllocations
    /**
     * It will be one of the fcp dimension name provided during the publishing of the product.
     */
    val usageDimension: kotlin.String? = builder.usageDimension
    /**
     * Consumption value for the hour. Defaults to `0` if not specified.
     */
    val usageQuantity: kotlin.Int? = builder.usageQuantity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MeterUsageRequest(")
        append("dryRun=$dryRun,")
        append("productCode=$productCode,")
        append("timestamp=$timestamp,")
        append("usageAllocations=$usageAllocations,")
        append("usageDimension=$usageDimension,")
        append("usageQuantity=$usageQuantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (usageAllocations?.hashCode() ?: 0)
        result = 31 * result + (usageDimension?.hashCode() ?: 0)
        result = 31 * result + (usageQuantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MeterUsageRequest

        if (dryRun != other.dryRun) return false
        if (productCode != other.productCode) return false
        if (timestamp != other.timestamp) return false
        if (usageAllocations != other.usageAllocations) return false
        if (usageDimension != other.usageDimension) return false
        if (usageQuantity != other.usageQuantity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the permissions required for the action, but does not make the request. If you have the permissions, the request returns `DryRunOperation`; otherwise, it returns `UnauthorizedException`. Defaults to `false` if not specified.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as the one used during the publishing of a new product.
         */
        var productCode: kotlin.String? = null
        /**
         * Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one hour in the past. Make sure the `timestamp` value is not before the start of the software usage.
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The set of `UsageAllocations` to submit.
         *
         * The sum of all `UsageAllocation` quantities must equal the `UsageQuantity` of the `MeterUsage` request, and each `UsageAllocation` must have a unique set of tags (include no tags).
         */
        var usageAllocations: List<UsageAllocation>? = null
        /**
         * It will be one of the fcp dimension name provided during the publishing of the product.
         */
        var usageDimension: kotlin.String? = null
        /**
         * Consumption value for the hour. Defaults to `0` if not specified.
         */
        var usageQuantity: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest) : this() {
            this.dryRun = x.dryRun
            this.productCode = x.productCode
            this.timestamp = x.timestamp
            this.usageAllocations = x.usageAllocations
            this.usageDimension = x.usageDimension
            this.usageQuantity = x.usageQuantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest = MeterUsageRequest(this)
    }
}
