// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediaconnect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediaconnect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * API for AWS Elemental MediaConnect
 */
interface MediaConnectClient : SdkClient {

    override val serviceName: String
        get() = "MediaConnect"
    /**
     * MediaConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MediaConnectClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaConnectClient(config)
        }

        operator fun invoke(config: Config): MediaConnectClient = DefaultMediaConnectClient(config)

        /**
         * Construct a [MediaConnectClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaConnectClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaConnectClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    suspend fun addFlowMediaStreams(input: AddFlowMediaStreamsRequest): AddFlowMediaStreamsResponse

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    suspend fun addFlowOutputs(input: AddFlowOutputsRequest): AddFlowOutputsResponse

    /**
     * Adds Sources to flow
     */
    suspend fun addFlowSources(input: AddFlowSourcesRequest): AddFlowSourcesResponse

    /**
     * Adds VPC interfaces to flow
     */
    suspend fun addFlowVpcInterfaces(input: AddFlowVpcInterfacesRequest): AddFlowVpcInterfacesResponse

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse

    /**
     * Grants entitlements to an existing flow.
     */
    suspend fun grantFlowEntitlements(input: GrantFlowEntitlementsRequest): GrantFlowEntitlementsResponse

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    suspend fun listEntitlements(input: ListEntitlementsRequest = ListEntitlementsRequest {}): ListEntitlementsResponse

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    suspend fun listFlows(input: ListFlowsRequest = ListFlowsRequest {}): ListFlowsResponse

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    suspend fun listOfferings(input: ListOfferingsRequest = ListOfferingsRequest {}): ListOfferingsResponse

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    suspend fun listReservations(input: ListReservationsRequest = ListReservationsRequest {}): ListReservationsResponse

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    suspend fun removeFlowMediaStream(input: RemoveFlowMediaStreamRequest): RemoveFlowMediaStreamResponse

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    suspend fun removeFlowOutput(input: RemoveFlowOutputRequest): RemoveFlowOutputResponse

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    suspend fun removeFlowSource(input: RemoveFlowSourceRequest): RemoveFlowSourceResponse

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    suspend fun removeFlowVpcInterface(input: RemoveFlowVpcInterfaceRequest): RemoveFlowVpcInterfaceResponse

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    suspend fun revokeFlowEntitlement(input: RevokeFlowEntitlementRequest): RevokeFlowEntitlementResponse

    /**
     * Starts a flow.
     */
    suspend fun startFlow(input: StartFlowRequest): StartFlowResponse

    /**
     * Stops a flow.
     */
    suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates flow
     */
    suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    suspend fun updateFlowEntitlement(input: UpdateFlowEntitlementRequest): UpdateFlowEntitlementResponse

    /**
     * Updates an existing media stream.
     */
    suspend fun updateFlowMediaStream(input: UpdateFlowMediaStreamRequest): UpdateFlowMediaStreamResponse

    /**
     * Updates an existing flow output.
     */
    suspend fun updateFlowOutput(input: UpdateFlowOutputRequest): UpdateFlowOutputResponse

    /**
     * Updates the source of a flow.
     */
    suspend fun updateFlowSource(input: UpdateFlowSourceRequest): UpdateFlowSourceResponse
}

/**
 * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
 */
suspend inline fun MediaConnectClient.addFlowMediaStreams(crossinline block: AddFlowMediaStreamsRequest.Builder.() -> Unit) = addFlowMediaStreams(AddFlowMediaStreamsRequest.Builder().apply(block).build())

/**
 * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
 */
suspend inline fun MediaConnectClient.addFlowOutputs(crossinline block: AddFlowOutputsRequest.Builder.() -> Unit) = addFlowOutputs(AddFlowOutputsRequest.Builder().apply(block).build())

/**
 * Adds Sources to flow
 */
suspend inline fun MediaConnectClient.addFlowSources(crossinline block: AddFlowSourcesRequest.Builder.() -> Unit) = addFlowSources(AddFlowSourcesRequest.Builder().apply(block).build())

/**
 * Adds VPC interfaces to flow
 */
suspend inline fun MediaConnectClient.addFlowVpcInterfaces(crossinline block: AddFlowVpcInterfacesRequest.Builder.() -> Unit) = addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.Builder().apply(block).build())

/**
 * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
 */
suspend inline fun MediaConnectClient.createFlow(crossinline block: CreateFlowRequest.Builder.() -> Unit) = createFlow(CreateFlowRequest.Builder().apply(block).build())

/**
 * Deletes a flow. Before you can delete a flow, you must stop the flow.
 */
suspend inline fun MediaConnectClient.deleteFlow(crossinline block: DeleteFlowRequest.Builder.() -> Unit) = deleteFlow(DeleteFlowRequest.Builder().apply(block).build())

/**
 * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
 */
suspend inline fun MediaConnectClient.describeFlow(crossinline block: DescribeFlowRequest.Builder.() -> Unit) = describeFlow(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
 */
suspend inline fun MediaConnectClient.describeOffering(crossinline block: DescribeOfferingRequest.Builder.() -> Unit) = describeOffering(DescribeOfferingRequest.Builder().apply(block).build())

/**
 * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
 */
suspend inline fun MediaConnectClient.describeReservation(crossinline block: DescribeReservationRequest.Builder.() -> Unit) = describeReservation(DescribeReservationRequest.Builder().apply(block).build())

/**
 * Grants entitlements to an existing flow.
 */
suspend inline fun MediaConnectClient.grantFlowEntitlements(crossinline block: GrantFlowEntitlementsRequest.Builder.() -> Unit) = grantFlowEntitlements(GrantFlowEntitlementsRequest.Builder().apply(block).build())

/**
 * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
 */
suspend inline fun MediaConnectClient.listEntitlements(crossinline block: ListEntitlementsRequest.Builder.() -> Unit) = listEntitlements(ListEntitlementsRequest.Builder().apply(block).build())

/**
 * Displays a list of flows that are associated with this account. This request returns a paginated result.
 */
suspend inline fun MediaConnectClient.listFlows(crossinline block: ListFlowsRequest.Builder.() -> Unit) = listFlows(ListFlowsRequest.Builder().apply(block).build())

/**
 * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
 */
suspend inline fun MediaConnectClient.listOfferings(crossinline block: ListOfferingsRequest.Builder.() -> Unit) = listOfferings(ListOfferingsRequest.Builder().apply(block).build())

/**
 * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
 */
suspend inline fun MediaConnectClient.listReservations(crossinline block: ListReservationsRequest.Builder.() -> Unit) = listReservations(ListReservationsRequest.Builder().apply(block).build())

/**
 * List all tags on an AWS Elemental MediaConnect resource
 */
suspend inline fun MediaConnectClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
 */
suspend inline fun MediaConnectClient.purchaseOffering(crossinline block: PurchaseOfferingRequest.Builder.() -> Unit) = purchaseOffering(PurchaseOfferingRequest.Builder().apply(block).build())

/**
 * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
 */
suspend inline fun MediaConnectClient.removeFlowMediaStream(crossinline block: RemoveFlowMediaStreamRequest.Builder.() -> Unit) = removeFlowMediaStream(RemoveFlowMediaStreamRequest.Builder().apply(block).build())

/**
 * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
 */
suspend inline fun MediaConnectClient.removeFlowOutput(crossinline block: RemoveFlowOutputRequest.Builder.() -> Unit) = removeFlowOutput(RemoveFlowOutputRequest.Builder().apply(block).build())

/**
 * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
 */
suspend inline fun MediaConnectClient.removeFlowSource(crossinline block: RemoveFlowSourceRequest.Builder.() -> Unit) = removeFlowSource(RemoveFlowSourceRequest.Builder().apply(block).build())

/**
 * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
 */
suspend inline fun MediaConnectClient.removeFlowVpcInterface(crossinline block: RemoveFlowVpcInterfaceRequest.Builder.() -> Unit) = removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.Builder().apply(block).build())

/**
 * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
 */
suspend inline fun MediaConnectClient.revokeFlowEntitlement(crossinline block: RevokeFlowEntitlementRequest.Builder.() -> Unit) = revokeFlowEntitlement(RevokeFlowEntitlementRequest.Builder().apply(block).build())

/**
 * Starts a flow.
 */
suspend inline fun MediaConnectClient.startFlow(crossinline block: StartFlowRequest.Builder.() -> Unit) = startFlow(StartFlowRequest.Builder().apply(block).build())

/**
 * Stops a flow.
 */
suspend inline fun MediaConnectClient.stopFlow(crossinline block: StopFlowRequest.Builder.() -> Unit) = stopFlow(StopFlowRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
 */
suspend inline fun MediaConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
suspend inline fun MediaConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates flow
 */
suspend inline fun MediaConnectClient.updateFlow(crossinline block: UpdateFlowRequest.Builder.() -> Unit) = updateFlow(UpdateFlowRequest.Builder().apply(block).build())

/**
 * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
 */
suspend inline fun MediaConnectClient.updateFlowEntitlement(crossinline block: UpdateFlowEntitlementRequest.Builder.() -> Unit) = updateFlowEntitlement(UpdateFlowEntitlementRequest.Builder().apply(block).build())

/**
 * Updates an existing media stream.
 */
suspend inline fun MediaConnectClient.updateFlowMediaStream(crossinline block: UpdateFlowMediaStreamRequest.Builder.() -> Unit) = updateFlowMediaStream(UpdateFlowMediaStreamRequest.Builder().apply(block).build())

/**
 * Updates an existing flow output.
 */
suspend inline fun MediaConnectClient.updateFlowOutput(crossinline block: UpdateFlowOutputRequest.Builder.() -> Unit) = updateFlowOutput(UpdateFlowOutputRequest.Builder().apply(block).build())

/**
 * Updates the source of a flow.
 */
suspend inline fun MediaConnectClient.updateFlowSource(crossinline block: UpdateFlowSourceRequest.Builder.() -> Unit) = updateFlowSource(UpdateFlowSourceRequest.Builder().apply(block).build())
