// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that you want to add to the flow.
 */
class AddMediaStreamRequest private constructor(builder: Builder) {
    /**
     * The attributes that you want to assign to the new media stream.
     */
    val attributes: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest? = builder.attributes
    /**
     * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     */
    val clockRate: kotlin.Int? = builder.clockRate
    /**
     * A description that can help you quickly identify what your media stream is used for.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the media stream.
     */
    val mediaStreamId: kotlin.Int? = builder.mediaStreamId
    /**
     * A name that helps you distinguish one media stream from another.
     */
    val mediaStreamName: kotlin.String? = builder.mediaStreamName
    /**
     * The type of media stream.
     */
    val mediaStreamType: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamType? = builder.mediaStreamType
    /**
     * The resolution of the video.
     */
    val videoFormat: kotlin.String? = builder.videoFormat

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.AddMediaStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddMediaStreamRequest(")
        append("attributes=$attributes,")
        append("clockRate=$clockRate,")
        append("description=$description,")
        append("mediaStreamId=$mediaStreamId,")
        append("mediaStreamName=$mediaStreamName,")
        append("mediaStreamType=$mediaStreamType,")
        append("videoFormat=$videoFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clockRate ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamId ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamType?.hashCode() ?: 0)
        result = 31 * result + (videoFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddMediaStreamRequest

        if (attributes != other.attributes) return false
        if (clockRate != other.clockRate) return false
        if (description != other.description) return false
        if (mediaStreamId != other.mediaStreamId) return false
        if (mediaStreamName != other.mediaStreamName) return false
        if (mediaStreamType != other.mediaStreamType) return false
        if (videoFormat != other.videoFormat) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.AddMediaStreamRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The attributes that you want to assign to the new media stream.
         */
        var attributes: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest? = null
        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         */
        var clockRate: kotlin.Int? = null
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the media stream.
         */
        var mediaStreamId: kotlin.Int? = null
        /**
         * A name that helps you distinguish one media stream from another.
         */
        var mediaStreamName: kotlin.String? = null
        /**
         * The type of media stream.
         */
        var mediaStreamType: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamType? = null
        /**
         * The resolution of the video.
         */
        var videoFormat: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.AddMediaStreamRequest) : this() {
            this.attributes = x.attributes
            this.clockRate = x.clockRate
            this.description = x.description
            this.mediaStreamId = x.mediaStreamId
            this.mediaStreamName = x.mediaStreamName
            this.mediaStreamType = x.mediaStreamType
            this.videoFormat = x.videoFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.AddMediaStreamRequest = AddMediaStreamRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest] inside the given [block]
         */
        fun attributes(block: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest.Builder.() -> kotlin.Unit) {
            this.attributes = aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest.invoke(block)
        }
    }
}
