// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The output that you want to add to this flow.
 */
class AddOutputRequest private constructor(builder: Builder) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
     */
    val description: kotlin.String? = builder.description
    /**
     * The IP address from which video will be sent to output destinations.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.encryption
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
     */
    val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    val mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = builder.mediaStreamOutputConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The name of the output. This value must be unique within the current flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The port to use when content is distributed to this output.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for the output.
     */
    val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull output stream.
     */
    val remoteId: kotlin.String? = builder.remoteId
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    val smoothingLatency: kotlin.Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: kotlin.String? = builder.streamId
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    val vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddOutputRequest(")
        append("cidrAllowList=$cidrAllowList,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("maxLatency=$maxLatency,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("minLatency=$minLatency,")
        append("name=$name,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("senderControlPort=$senderControlPort,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddOutputRequest

        if (cidrAllowList != other.cidrAllowList) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (maxLatency != other.maxLatency) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (name != other.name) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (senderControlPort != other.senderControlPort) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var cidrAllowList: List<String>? = null
        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
         */
        var description: kotlin.String? = null
        /**
         * The IP address from which video will be sent to output destinations.
         */
        var destination: kotlin.String? = null
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
         */
        var maxLatency: kotlin.Int? = null
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         */
        var mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: kotlin.Int? = null
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        var name: kotlin.String? = null
        /**
         * The port to use when content is distributed to this output.
         */
        var port: kotlin.Int? = null
        /**
         * The protocol to use for the output.
         */
        var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The remote ID for the Zixi-pull output stream.
         */
        var remoteId: kotlin.String? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        var senderControlPort: kotlin.Int? = null
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        var smoothingLatency: kotlin.Int? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: kotlin.String? = null
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        var vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.maxLatency = x.maxLatency
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.minLatency = x.minLatency
            this.name = x.name
            this.port = x.port
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.senderControlPort = x.senderControlPort
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = AddOutputRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        fun vpcInterfaceAttachment(block: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.invoke(block)
        }
    }
}
