// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
 */
class CreateFlowRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The entitlements that you want to grant on a flow.
     */
    val entitlements: List<GrantEntitlementRequest>? = builder.entitlements
    /**
     * Create maintenance setting for a flow
     */
    val maintenance: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance? = builder.maintenance
    /**
     * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
     */
    val mediaStreams: List<AddMediaStreamRequest>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The outputs that you want to add to this flow.
     */
    val outputs: List<AddOutputRequest>? = builder.outputs
    /**
     * The settings for the source of the flow.
     */
    val source: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest? = builder.source
    /**
     * The settings for source failover.
     */
    val sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = builder.sourceFailoverConfig
    val sources: List<SetSourceRequest>? = builder.sources
    /**
     * The VPC interfaces you want on the flow.
     */
    val vpcInterfaces: List<VpcInterfaceRequest>? = builder.vpcInterfaces

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowRequest(")
        append("availabilityZone=$availabilityZone,")
        append("entitlements=$entitlements,")
        append("maintenance=$maintenance,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sources=$sources,")
        append("vpcInterfaces=$vpcInterfaces)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (maintenance?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFlowRequest

        if (availabilityZone != other.availabilityZone) return false
        if (entitlements != other.entitlements) return false
        if (maintenance != other.maintenance) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sources != other.sources) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The entitlements that you want to grant on a flow.
         */
        var entitlements: List<GrantEntitlementRequest>? = null
        /**
         * Create maintenance setting for a flow
         */
        var maintenance: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance? = null
        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
         */
        var mediaStreams: List<AddMediaStreamRequest>? = null
        /**
         * The name of the flow.
         */
        var name: kotlin.String? = null
        /**
         * The outputs that you want to add to this flow.
         */
        var outputs: List<AddOutputRequest>? = null
        /**
         * The settings for the source of the flow.
         */
        var source: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest? = null
        /**
         * The settings for source failover.
         */
        var sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = null
        var sources: List<SetSourceRequest>? = null
        /**
         * The VPC interfaces you want on the flow.
         */
        var vpcInterfaces: List<VpcInterfaceRequest>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.entitlements = x.entitlements
            this.maintenance = x.maintenance
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sources = x.sources
            this.vpcInterfaces = x.vpcInterfaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = CreateFlowRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance] inside the given [block]
         */
        fun maintenance(block: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance.Builder.() -> kotlin.Unit) {
            this.maintenance = aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest] inside the given [block]
         */
        fun source(block: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        fun sourceFailoverConfig(block: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.Builder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.invoke(block)
        }
    }
}
