// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
 */
class EncodingParameters private constructor(builder: Builder) {
    /**
     * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
     */
    val compressionFactor: kotlin.Double? = builder.compressionFactor
    /**
     * A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
     */
    val encoderProfile: aws.sdk.kotlin.services.mediaconnect.model.EncoderProfile? = builder.encoderProfile

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncodingParameters(")
        append("compressionFactor=$compressionFactor,")
        append("encoderProfile=$encoderProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionFactor?.hashCode() ?: 0
        result = 31 * result + (encoderProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncodingParameters

        if (compressionFactor != other.compressionFactor) return false
        if (encoderProfile != other.encoderProfile) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
         */
        var compressionFactor: kotlin.Double? = null
        /**
         * A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         */
        var encoderProfile: aws.sdk.kotlin.services.mediaconnect.model.EncoderProfile? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters) : this() {
            this.compressionFactor = x.compressionFactor
            this.encoderProfile = x.encoderProfile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters = EncodingParameters(this)
    }
}
