// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
 */
class MediaStream private constructor(builder: Builder) {
    /**
     * Attributes that are related to the media stream.
     */
    val attributes: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes? = builder.attributes
    /**
     * The sample rate for the stream. This value is measured in Hz.
     */
    val clockRate: kotlin.Int? = builder.clockRate
    /**
     * A description that can help you quickly identify what your media stream is used for.
     */
    val description: kotlin.String? = builder.description
    /**
     * The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
     */
    val fmt: kotlin.Int? = builder.fmt
    /**
     * A unique identifier for the media stream.
     */
    val mediaStreamId: kotlin.Int? = builder.mediaStreamId
    /**
     * A name that helps you distinguish one media stream from another.
     */
    val mediaStreamName: kotlin.String? = builder.mediaStreamName
    /**
     * The type of media stream.
     */
    val mediaStreamType: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamType? = builder.mediaStreamType
    /**
     * The resolution of the video.
     */
    val videoFormat: kotlin.String? = builder.videoFormat

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.MediaStream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStream(")
        append("attributes=$attributes,")
        append("clockRate=$clockRate,")
        append("description=$description,")
        append("fmt=$fmt,")
        append("mediaStreamId=$mediaStreamId,")
        append("mediaStreamName=$mediaStreamName,")
        append("mediaStreamType=$mediaStreamType,")
        append("videoFormat=$videoFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clockRate ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fmt ?: 0)
        result = 31 * result + (mediaStreamId ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamType?.hashCode() ?: 0)
        result = 31 * result + (videoFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaStream

        if (attributes != other.attributes) return false
        if (clockRate != other.clockRate) return false
        if (description != other.description) return false
        if (fmt != other.fmt) return false
        if (mediaStreamId != other.mediaStreamId) return false
        if (mediaStreamName != other.mediaStreamName) return false
        if (mediaStreamType != other.mediaStreamType) return false
        if (videoFormat != other.videoFormat) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.MediaStream = Builder(this).apply(block).build()

    class Builder {
        /**
         * Attributes that are related to the media stream.
         */
        var attributes: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes? = null
        /**
         * The sample rate for the stream. This value is measured in Hz.
         */
        var clockRate: kotlin.Int? = null
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        var description: kotlin.String? = null
        /**
         * The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
         */
        var fmt: kotlin.Int? = null
        /**
         * A unique identifier for the media stream.
         */
        var mediaStreamId: kotlin.Int? = null
        /**
         * A name that helps you distinguish one media stream from another.
         */
        var mediaStreamName: kotlin.String? = null
        /**
         * The type of media stream.
         */
        var mediaStreamType: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamType? = null
        /**
         * The resolution of the video.
         */
        var videoFormat: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.MediaStream) : this() {
            this.attributes = x.attributes
            this.clockRate = x.clockRate
            this.description = x.description
            this.fmt = x.fmt
            this.mediaStreamId = x.mediaStreamId
            this.mediaStreamName = x.mediaStreamName
            this.mediaStreamType = x.mediaStreamType
            this.videoFormat = x.videoFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.MediaStream = MediaStream(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes] inside the given [block]
         */
        fun attributes(block: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes.Builder.() -> kotlin.Unit) {
            this.attributes = aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes.invoke(block)
        }
    }
}
