// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that is associated with the output, and the parameters for that association.
 */
class MediaStreamOutputConfiguration private constructor(builder: Builder) {
    /**
     * The transport parameters that are associated with each outbound media stream.
     */
    val destinationConfigurations: List<DestinationConfiguration>? = builder.destinationConfigurations
    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = builder.encodingName
    /**
     * Encoding parameters
     */
    val encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters? = builder.encodingParameters
    /**
     * The name of the media stream.
     */
    val mediaStreamName: kotlin.String? = builder.mediaStreamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamOutputConfiguration(")
        append("destinationConfigurations=$destinationConfigurations,")
        append("encodingName=$encodingName,")
        append("encodingParameters=$encodingParameters,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfigurations?.hashCode() ?: 0
        result = 31 * result + (encodingName?.hashCode() ?: 0)
        result = 31 * result + (encodingParameters?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaStreamOutputConfiguration

        if (destinationConfigurations != other.destinationConfigurations) return false
        if (encodingName != other.encodingName) return false
        if (encodingParameters != other.encodingParameters) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The transport parameters that are associated with each outbound media stream.
         */
        var destinationConfigurations: List<DestinationConfiguration>? = null
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = null
        /**
         * Encoding parameters
         */
        var encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters? = null
        /**
         * The name of the media stream.
         */
        var mediaStreamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration) : this() {
            this.destinationConfigurations = x.destinationConfigurations
            this.encodingName = x.encodingName
            this.encodingParameters = x.encodingParameters
            this.mediaStreamName = x.mediaStreamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = MediaStreamOutputConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters] inside the given [block]
         */
        fun encodingParameters(block: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters.Builder.() -> kotlin.Unit) {
            this.encodingParameters = aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters.invoke(block)
        }
    }
}
