// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that is associated with the source, and the parameters for that association.
 */
class MediaStreamSourceConfiguration private constructor(builder: Builder) {
    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = builder.encodingName
    /**
     * The transport parameters that are associated with an incoming media stream.
     */
    val inputConfigurations: List<InputConfiguration>? = builder.inputConfigurations
    /**
     * The name of the media stream.
     */
    val mediaStreamName: kotlin.String? = builder.mediaStreamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamSourceConfiguration(")
        append("encodingName=$encodingName,")
        append("inputConfigurations=$inputConfigurations,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodingName?.hashCode() ?: 0
        result = 31 * result + (inputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaStreamSourceConfiguration

        if (encodingName != other.encodingName) return false
        if (inputConfigurations != other.inputConfigurations) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamSourceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = null
        /**
         * The transport parameters that are associated with an incoming media stream.
         */
        var inputConfigurations: List<InputConfiguration>? = null
        /**
         * The name of the media stream.
         */
        var mediaStreamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamSourceConfiguration) : this() {
            this.encodingName = x.encodingName
            this.inputConfigurations = x.inputConfigurations
            this.mediaStreamName = x.mediaStreamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamSourceConfiguration = MediaStreamSourceConfiguration(this)
    }
}
