// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for an output.
 */
class Output private constructor(builder: Builder) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    val dataTransferSubscriberFeePercent: kotlin.Int? = builder.dataTransferSubscriberFeePercent
    /**
     * A description of the output.
     */
    val description: kotlin.String? = builder.description
    /**
     * The address where you want to send the output.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.encryption
    /**
     * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
     */
    val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
     */
    val listenerAddress: kotlin.String? = builder.listenerAddress
    /**
     * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
     */
    val mediaLiveInputArn: kotlin.String? = builder.mediaLiveInputArn
    /**
     * The configuration for each media stream that is associated with the output.
     */
    val mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = builder.mediaStreamOutputConfigurations
    /**
     * The name of the output. This value must be unique within the current flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the output.
     */
    val outputArn: kotlin.String? = builder.outputArn
    /**
     * The port to use when content is distributed to this output.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Attributes related to the transport stream that are used in the output.
     */
    val transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = builder.transport
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    val vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Output = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Output(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("listenerAddress=$listenerAddress,")
        append("mediaLiveInputArn=$mediaLiveInputArn,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("name=$name,")
        append("outputArn=$outputArn,")
        append("port=$port,")
        append("transport=$transport,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (listenerAddress?.hashCode() ?: 0)
        result = 31 * result + (mediaLiveInputArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Output

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (listenerAddress != other.listenerAddress) return false
        if (mediaLiveInputArn != other.mediaLiveInputArn) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (name != other.name) return false
        if (outputArn != other.outputArn) return false
        if (port != other.port) return false
        if (transport != other.transport) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Output = Builder(this).apply(block).build()

    class Builder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        var dataTransferSubscriberFeePercent: kotlin.Int? = null
        /**
         * A description of the output.
         */
        var description: kotlin.String? = null
        /**
         * The address where you want to send the output.
         */
        var destination: kotlin.String? = null
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         */
        var entitlementArn: kotlin.String? = null
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
         */
        var listenerAddress: kotlin.String? = null
        /**
         * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
         */
        var mediaLiveInputArn: kotlin.String? = null
        /**
         * The configuration for each media stream that is associated with the output.
         */
        var mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = null
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the output.
         */
        var outputArn: kotlin.String? = null
        /**
         * The port to use when content is distributed to this output.
         */
        var port: kotlin.Int? = null
        /**
         * Attributes related to the transport stream that are used in the output.
         */
        var transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = null
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        var vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Output) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.listenerAddress = x.listenerAddress
            this.mediaLiveInputArn = x.mediaLiveInputArn
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.name = x.name
            this.outputArn = x.outputArn
            this.port = x.port
            this.transport = x.transport
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Output = Output(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        fun transport(block: aws.sdk.kotlin.services.mediaconnect.model.Transport.Builder.() -> kotlin.Unit) {
            this.transport = aws.sdk.kotlin.services.mediaconnect.model.Transport.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        fun vpcInterfaceAttachment(block: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.invoke(block)
        }
    }
}
