// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Attributes related to the transport stream that are used in a source or output.
 */
class Transport private constructor(builder: Builder) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
     */
    val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    val maxSyncBuffer: kotlin.Int? = builder.maxSyncBuffer
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The protocol that is used by the source or output.
     */
    val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull stream.
     */
    val remoteId: kotlin.String? = builder.remoteId
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    val smoothingLatency: kotlin.Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: kotlin.String? = builder.streamId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Transport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Transport(")
        append("cidrAllowList=$cidrAllowList,")
        append("maxBitrate=$maxBitrate,")
        append("maxLatency=$maxLatency,")
        append("maxSyncBuffer=$maxSyncBuffer,")
        append("minLatency=$minLatency,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("senderControlPort=$senderControlPort,")
        append("senderIpAddress=$senderIpAddress,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (maxSyncBuffer ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Transport

        if (cidrAllowList != other.cidrAllowList) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxLatency != other.maxLatency) return false
        if (maxSyncBuffer != other.maxSyncBuffer) return false
        if (minLatency != other.minLatency) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (senderControlPort != other.senderControlPort) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Transport = Builder(this).apply(block).build()

    class Builder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var cidrAllowList: List<String>? = null
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        var maxBitrate: kotlin.Int? = null
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
         */
        var maxLatency: kotlin.Int? = null
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        var maxSyncBuffer: kotlin.Int? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: kotlin.Int? = null
        /**
         * The protocol that is used by the source or output.
         */
        var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The remote ID for the Zixi-pull stream.
         */
        var remoteId: kotlin.String? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        var senderControlPort: kotlin.Int? = null
        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         */
        var senderIpAddress: kotlin.String? = null
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        var smoothingLatency: kotlin.Int? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Transport) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.maxBitrate = x.maxBitrate
            this.maxLatency = x.maxLatency
            this.maxSyncBuffer = x.maxSyncBuffer
            this.minLatency = x.minLatency
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.senderControlPort = x.senderControlPort
            this.senderIpAddress = x.senderIpAddress
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Transport = Transport(this)
    }
}
