// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A request to update the source of a flow.
 */
class UpdateFlowSourceRequest private constructor(builder: Builder) {
    /**
     * The type of encryption used on the content ingested from this source.
     */
    val decryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = builder.decryption
    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
     */
    val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The flow that is associated with the source that you want to update.
     */
    val flowArn: kotlin.String? = requireNotNull(builder.flowArn) { "A non-null value must be provided for flowArn" }
    /**
     * The port that the flow will be listening on for incoming content.
     */
    val ingestPort: kotlin.Int? = builder.ingestPort
    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
     */
    val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    val maxSyncBuffer: kotlin.Int? = builder.maxSyncBuffer
    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     */
    val mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = builder.mediaStreamSourceConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The protocol that is used by the source.
     */
    val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * The ARN of the source that you want to update.
     */
    val sourceArn: kotlin.String? = requireNotNull(builder.sourceArn) { "A non-null value must be provided for sourceArn" }
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: kotlin.String? = builder.streamId
    /**
     * The name of the VPC interface to use for this source.
     */
    val vpcInterfaceName: kotlin.String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val whitelistCidr: kotlin.String? = builder.whitelistCidr

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowSourceRequest(")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("flowArn=$flowArn,")
        append("ingestPort=$ingestPort,")
        append("maxBitrate=$maxBitrate,")
        append("maxLatency=$maxLatency,")
        append("maxSyncBuffer=$maxSyncBuffer,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("minLatency=$minLatency,")
        append("protocol=$protocol,")
        append("senderControlPort=$senderControlPort,")
        append("senderIpAddress=$senderIpAddress,")
        append("sourceArn=$sourceArn,")
        append("streamId=$streamId,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = decryption?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (maxSyncBuffer ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFlowSourceRequest

        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (flowArn != other.flowArn) return false
        if (ingestPort != other.ingestPort) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxLatency != other.maxLatency) return false
        if (maxSyncBuffer != other.maxSyncBuffer) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (protocol != other.protocol) return false
        if (senderControlPort != other.senderControlPort) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (sourceArn != other.sourceArn) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of encryption used on the content ingested from this source.
         */
        var decryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = null
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: kotlin.String? = null
        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
         */
        var entitlementArn: kotlin.String? = null
        /**
         * The flow that is associated with the source that you want to update.
         */
        var flowArn: kotlin.String? = null
        /**
         * The port that the flow will be listening on for incoming content.
         */
        var ingestPort: kotlin.Int? = null
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        var maxBitrate: kotlin.Int? = null
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
         */
        var maxLatency: kotlin.Int? = null
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        var maxSyncBuffer: kotlin.Int? = null
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        var mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: kotlin.Int? = null
        /**
         * The protocol that is used by the source.
         */
        var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        var senderControlPort: kotlin.Int? = null
        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         */
        var senderIpAddress: kotlin.String? = null
        /**
         * The ARN of the source that you want to update.
         */
        var sourceArn: kotlin.String? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: kotlin.String? = null
        /**
         * The name of the VPC interface to use for this source.
         */
        var vpcInterfaceName: kotlin.String? = null
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var whitelistCidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest) : this() {
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.flowArn = x.flowArn
            this.ingestPort = x.ingestPort
            this.maxBitrate = x.maxBitrate
            this.maxLatency = x.maxLatency
            this.maxSyncBuffer = x.maxSyncBuffer
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.minLatency = x.minLatency
            this.protocol = x.protocol
            this.senderControlPort = x.senderControlPort
            this.senderIpAddress = x.senderIpAddress
            this.sourceArn = x.sourceArn
            this.streamId = x.streamId
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = UpdateFlowSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption] inside the given [block]
         */
        fun decryption(block: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.Builder.() -> kotlin.Unit) {
            this.decryption = aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.invoke(block)
        }
    }
}
