// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Desired VPC Interface for a Flow
 */
class VpcInterfaceRequest private constructor(builder: Builder) {
    /**
     * The name of the VPC Interface. This value must be unique within the current flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
     */
    val networkInterfaceType: aws.sdk.kotlin.services.mediaconnect.model.NetworkInterfaceType? = builder.networkInterfaceType
    /**
     * Role Arn MediaConnect can assumes to create ENIs in customer's account
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Security Group IDs to be used on ENI.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Subnet must be in the AZ of the Flow
     */
    val subnetId: kotlin.String? = builder.subnetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcInterfaceRequest(")
        append("name=$name,")
        append("networkInterfaceType=$networkInterfaceType,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcInterfaceRequest

        if (name != other.name) return false
        if (networkInterfaceType != other.networkInterfaceType) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the VPC Interface. This value must be unique within the current flow.
         */
        var name: kotlin.String? = null
        /**
         * The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
         */
        var networkInterfaceType: aws.sdk.kotlin.services.mediaconnect.model.NetworkInterfaceType? = null
        /**
         * Role Arn MediaConnect can assumes to create ENIs in customer's account
         */
        var roleArn: kotlin.String? = null
        /**
         * Security Group IDs to be used on ENI.
         */
        var securityGroupIds: List<String>? = null
        /**
         * Subnet must be in the AZ of the Flow
         */
        var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest) : this() {
            this.name = x.name
            this.networkInterfaceType = x.networkInterfaceType
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = VpcInterfaceRequest(this)
    }
}
