// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.Flow
import aws.sdk.kotlin.services.mediaconnect.model.MediaConnectException
import aws.sdk.kotlin.services.mediaconnect.model.Messages
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeFlowOperationDeserializer: HttpDeserialize<DescribeFlowResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFlowResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFlowError(context, response)
        }
        val builder = DescribeFlowResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFlowOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFlowError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFlowOperationBody(builder: DescribeFlowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("flow"))
    val MESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("messages"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLOW_DESCRIPTOR)
        field(MESSAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLOW_DESCRIPTOR.index -> builder.flow = deserializeFlowDocument(deserializer)
                MESSAGES_DESCRIPTOR.index -> builder.messages = deserializeMessagesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
