// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediaconnect.model.Entitlement
import aws.sdk.kotlin.services.mediaconnect.model.GrantFlowEntitlementsResponse
import aws.sdk.kotlin.services.mediaconnect.model.MediaConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GrantFlowEntitlementsOperationDeserializer: HttpDeserialize<GrantFlowEntitlementsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GrantFlowEntitlementsResponse {
        if (!response.status.isSuccess()) {
            throwGrantFlowEntitlementsError(context, response)
        }
        val builder = GrantFlowEntitlementsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGrantFlowEntitlementsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGrantFlowEntitlementsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GrantFlowEntitlements420Exception" -> GrantFlowEntitlements420ExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGrantFlowEntitlementsOperationBody(builder: GrantFlowEntitlementsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITLEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entitlements"))
    val FLOWARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITLEMENTS_DESCRIPTOR)
        field(FLOWARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITLEMENTS_DESCRIPTOR.index -> builder.entitlements =
                    deserializer.deserializeList(ENTITLEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Entitlement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEntitlementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FLOWARN_DESCRIPTOR.index -> builder.flowArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
