// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediaconnect.model.ListEntitlementsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListedEntitlement
import aws.sdk.kotlin.services.mediaconnect.model.MediaConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListEntitlementsOperationDeserializer: HttpDeserialize<ListEntitlementsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListEntitlementsResponse {
        if (!response.status.isSuccess()) {
            throwListEntitlementsError(context, response)
        }
        val builder = ListEntitlementsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListEntitlementsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListEntitlementsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListEntitlementsOperationBody(builder: ListEntitlementsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITLEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entitlements"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITLEMENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITLEMENTS_DESCRIPTOR.index -> builder.entitlements =
                    deserializer.deserializeList(ENTITLEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ListedEntitlement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListedEntitlementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
