// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateMaintenance
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFlowOperationSerializer: HttpSerialize<UpdateFlowRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFlowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "v1",
                "flows",
                "${input.flowArn}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFlowOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowOperationBody(context: ExecutionContext, input: UpdateFlowRequest): ByteArray {
    val serializer = JsonSerializer()
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val SOURCEFAILOVERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceFailoverConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAINTENANCE_DESCRIPTOR)
        field(SOURCEFAILOVERCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.maintenance?.let { field(MAINTENANCE_DESCRIPTOR, it, ::serializeUpdateMaintenanceDocument) }
        input.sourceFailoverConfig?.let { field(SOURCEFAILOVERCONFIG_DESCRIPTOR, it, ::serializeUpdateFailoverConfigDocument) }
    }
    return serializer.toByteArray()
}
