// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.waiters

import aws.sdk.kotlin.services.mediaconnect.MediaConnectClient
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a flow is active
 */
suspend fun MediaConnectClient.waitUntilFlowActive(request: DescribeFlowRequest): Outcome<DescribeFlowResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 3_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "STARTING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "UPDATING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is active
 */
suspend fun MediaConnectClient.waitUntilFlowActive(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowActive(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Wait until a flow is deleted
 */
suspend fun MediaConnectClient.waitUntilFlowDeleted(request: DescribeFlowRequest): Outcome<DescribeFlowResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 3_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "NotFoundException"),
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "DELETING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is deleted
 */
suspend fun MediaConnectClient.waitUntilFlowDeleted(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowDeleted(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Wait until a flow is in standby mode
 */
suspend fun MediaConnectClient.waitUntilFlowStandby(request: DescribeFlowRequest): Outcome<DescribeFlowResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 3_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "STANDBY"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "STOPPING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it?.flow
            val status = flow?.status
            status?.toString() == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is in standby mode
 */
suspend fun MediaConnectClient.waitUntilFlowStandby(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowStandby(DescribeFlowRequest.Builder().apply(block).build())
