// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the rate control mode.
 */
class AacSettings private constructor(builder: Builder) {
    /**
     * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any values you provide for AudioType and FollowInputAudioType.
     */
    val audioDescriptionBroadcasterMix: aws.sdk.kotlin.services.mediaconvert.model.AacAudioDescriptionBroadcasterMix? = builder.audioDescriptionBroadcasterMix
    /**
     * Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000, 10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000. The value you set is also constrained by the values that you choose for Profile (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default values depend on Bitrate control mode and Profile.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * AAC Profile.
     */
    val codecProfile: aws.sdk.kotlin.services.mediaconvert.model.AacCodecProfile? = builder.codecProfile
    /**
     * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
     */
    val codingMode: aws.sdk.kotlin.services.mediaconvert.model.AacCodingMode? = builder.codingMode
    /**
     * Rate Control Mode.
     */
    val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.AacRateControlMode? = builder.rateControlMode
    /**
     * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for the output container.
     */
    val rawFormat: aws.sdk.kotlin.services.mediaconvert.model.AacRawFormat? = builder.rawFormat
    /**
     * Sample rate in Hz. Valid values depend on rate control mode and profile.
     */
    val sampleRate: kotlin.Int? = builder.sampleRate
    /**
     * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     */
    val specification: aws.sdk.kotlin.services.mediaconvert.model.AacSpecification? = builder.specification
    /**
     * VBR Quality Level - Only used if rate_control_mode is VBR.
     */
    val vbrQuality: aws.sdk.kotlin.services.mediaconvert.model.AacVbrQuality? = builder.vbrQuality

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AacSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AacSettings(")
        append("audioDescriptionBroadcasterMix=$audioDescriptionBroadcasterMix,")
        append("bitrate=$bitrate,")
        append("codecProfile=$codecProfile,")
        append("codingMode=$codingMode,")
        append("rateControlMode=$rateControlMode,")
        append("rawFormat=$rawFormat,")
        append("sampleRate=$sampleRate,")
        append("specification=$specification,")
        append("vbrQuality=$vbrQuality)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDescriptionBroadcasterMix?.hashCode() ?: 0
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (codecProfile?.hashCode() ?: 0)
        result = 31 * result + (codingMode?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (rawFormat?.hashCode() ?: 0)
        result = 31 * result + (sampleRate ?: 0)
        result = 31 * result + (specification?.hashCode() ?: 0)
        result = 31 * result + (vbrQuality?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AacSettings

        if (audioDescriptionBroadcasterMix != other.audioDescriptionBroadcasterMix) return false
        if (bitrate != other.bitrate) return false
        if (codecProfile != other.codecProfile) return false
        if (codingMode != other.codingMode) return false
        if (rateControlMode != other.rateControlMode) return false
        if (rawFormat != other.rawFormat) return false
        if (sampleRate != other.sampleRate) return false
        if (specification != other.specification) return false
        if (vbrQuality != other.vbrQuality) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AacSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any values you provide for AudioType and FollowInputAudioType.
         */
        var audioDescriptionBroadcasterMix: aws.sdk.kotlin.services.mediaconvert.model.AacAudioDescriptionBroadcasterMix? = null
        /**
         * Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000, 10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000. The value you set is also constrained by the values that you choose for Profile (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default values depend on Bitrate control mode and Profile.
         */
        var bitrate: kotlin.Int? = null
        /**
         * AAC Profile.
         */
        var codecProfile: aws.sdk.kotlin.services.mediaconvert.model.AacCodecProfile? = null
        /**
         * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         */
        var codingMode: aws.sdk.kotlin.services.mediaconvert.model.AacCodingMode? = null
        /**
         * Rate Control Mode.
         */
        var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.AacRateControlMode? = null
        /**
         * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for the output container.
         */
        var rawFormat: aws.sdk.kotlin.services.mediaconvert.model.AacRawFormat? = null
        /**
         * Sample rate in Hz. Valid values depend on rate control mode and profile.
         */
        var sampleRate: kotlin.Int? = null
        /**
         * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         */
        var specification: aws.sdk.kotlin.services.mediaconvert.model.AacSpecification? = null
        /**
         * VBR Quality Level - Only used if rate_control_mode is VBR.
         */
        var vbrQuality: aws.sdk.kotlin.services.mediaconvert.model.AacVbrQuality? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AacSettings) : this() {
            this.audioDescriptionBroadcasterMix = x.audioDescriptionBroadcasterMix
            this.bitrate = x.bitrate
            this.codecProfile = x.codecProfile
            this.codingMode = x.codingMode
            this.rateControlMode = x.rateControlMode
            this.rawFormat = x.rawFormat
            this.sampleRate = x.sampleRate
            this.specification = x.specification
            this.vbrQuality = x.vbrQuality
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AacSettings = AacSettings(this)
    }
}
