// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Burn-in is a captions delivery method, rather than a captions format. Burn-in writes the captions directly on your video frames, replacing pixels of video content with the captions. Set up burn-in captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to BURN_IN.
 */
class BurninDestinationSettings private constructor(builder: Builder) {
    /**
     * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates.
     */
    val alignment: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleAlignment? = builder.alignment
    /**
     * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies to white text in your input captions. For example, if your font color setting is Yellow, and your input captions have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions text.
     */
    val applyFontColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleApplyFontColor? = builder.applyFontColor
    /**
     * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if present.
     */
    val backgroundColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleBackgroundColor? = builder.backgroundColor
    /**
     * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the background style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions.
     */
    val backgroundOpacity: kotlin.Int? = builder.backgroundOpacity
    /**
     * Specify the font that you want the service to use for your burn in captions when your input captions specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
     */
    val fallbackFont: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleFallbackFont? = builder.fallbackFont
    /**
     * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present.
     */
    val fontColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleFontColor? = builder.fontColor
    /**
     * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
     */
    val fontOpacity: kotlin.Int? = builder.fontOpacity
    /**
     * Specify the Font resolution (FontResolution) in DPI (dots per inch).
     */
    val fontResolution: kotlin.Int? = builder.fontResolution
    /**
     * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
     */
    val fontScript: aws.sdk.kotlin.services.mediaconvert.model.FontScript? = builder.fontScript
    /**
     * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for automatic font size.
     */
    val fontSize: kotlin.Int? = builder.fontSize
    /**
     * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits, representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
     */
    val hexFontColor: kotlin.String? = builder.hexFontColor
    /**
     * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
     */
    val outlineColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleOutlineColor? = builder.outlineColor
    /**
     * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present.
     */
    val outlineSize: kotlin.Int? = builder.outlineSize
    /**
     * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
     */
    val shadowColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleShadowColor? = builder.shadowColor
    /**
     * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass through the shadow style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all shadows from your output captions.
     */
    val shadowOpacity: kotlin.Int? = builder.shadowOpacity
    /**
     * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
     */
    val shadowXOffset: kotlin.Int? = builder.shadowXOffset
    /**
     * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present.
     */
    val shadowYOffset: kotlin.Int? = builder.shadowYOffset
    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information from your input captions. MediaConvert uses default settings for any missing style and position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position information from your input captions and use default settings: white text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to manually override any of the individual style and position settings.
     */
    val stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.BurnInSubtitleStylePassthrough? = builder.stylePassthrough
    /**
     * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
     */
    val teletextSpacing: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleTeletextSpacing? = builder.teletextSpacing
    /**
     * Specify the horizontal position (XPosition) of the captions, relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit x_position is provided, the horizontal caption position will be determined by the alignment parameter.
     */
    val xPosition: kotlin.Int? = builder.xPosition
    /**
     * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output.
     */
    val yPosition: kotlin.Int? = builder.yPosition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BurninDestinationSettings(")
        append("alignment=$alignment,")
        append("applyFontColor=$applyFontColor,")
        append("backgroundColor=$backgroundColor,")
        append("backgroundOpacity=$backgroundOpacity,")
        append("fallbackFont=$fallbackFont,")
        append("fontColor=$fontColor,")
        append("fontOpacity=$fontOpacity,")
        append("fontResolution=$fontResolution,")
        append("fontScript=$fontScript,")
        append("fontSize=$fontSize,")
        append("hexFontColor=$hexFontColor,")
        append("outlineColor=$outlineColor,")
        append("outlineSize=$outlineSize,")
        append("shadowColor=$shadowColor,")
        append("shadowOpacity=$shadowOpacity,")
        append("shadowXOffset=$shadowXOffset,")
        append("shadowYOffset=$shadowYOffset,")
        append("stylePassthrough=$stylePassthrough,")
        append("teletextSpacing=$teletextSpacing,")
        append("xPosition=$xPosition,")
        append("yPosition=$yPosition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alignment?.hashCode() ?: 0
        result = 31 * result + (applyFontColor?.hashCode() ?: 0)
        result = 31 * result + (backgroundColor?.hashCode() ?: 0)
        result = 31 * result + (backgroundOpacity ?: 0)
        result = 31 * result + (fallbackFont?.hashCode() ?: 0)
        result = 31 * result + (fontColor?.hashCode() ?: 0)
        result = 31 * result + (fontOpacity ?: 0)
        result = 31 * result + (fontResolution ?: 0)
        result = 31 * result + (fontScript?.hashCode() ?: 0)
        result = 31 * result + (fontSize ?: 0)
        result = 31 * result + (hexFontColor?.hashCode() ?: 0)
        result = 31 * result + (outlineColor?.hashCode() ?: 0)
        result = 31 * result + (outlineSize ?: 0)
        result = 31 * result + (shadowColor?.hashCode() ?: 0)
        result = 31 * result + (shadowOpacity ?: 0)
        result = 31 * result + (shadowXOffset ?: 0)
        result = 31 * result + (shadowYOffset ?: 0)
        result = 31 * result + (stylePassthrough?.hashCode() ?: 0)
        result = 31 * result + (teletextSpacing?.hashCode() ?: 0)
        result = 31 * result + (xPosition ?: 0)
        result = 31 * result + (yPosition ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BurninDestinationSettings

        if (alignment != other.alignment) return false
        if (applyFontColor != other.applyFontColor) return false
        if (backgroundColor != other.backgroundColor) return false
        if (backgroundOpacity != other.backgroundOpacity) return false
        if (fallbackFont != other.fallbackFont) return false
        if (fontColor != other.fontColor) return false
        if (fontOpacity != other.fontOpacity) return false
        if (fontResolution != other.fontResolution) return false
        if (fontScript != other.fontScript) return false
        if (fontSize != other.fontSize) return false
        if (hexFontColor != other.hexFontColor) return false
        if (outlineColor != other.outlineColor) return false
        if (outlineSize != other.outlineSize) return false
        if (shadowColor != other.shadowColor) return false
        if (shadowOpacity != other.shadowOpacity) return false
        if (shadowXOffset != other.shadowXOffset) return false
        if (shadowYOffset != other.shadowYOffset) return false
        if (stylePassthrough != other.stylePassthrough) return false
        if (teletextSpacing != other.teletextSpacing) return false
        if (xPosition != other.xPosition) return false
        if (yPosition != other.yPosition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates.
         */
        var alignment: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleAlignment? = null
        /**
         * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies to white text in your input captions. For example, if your font color setting is Yellow, and your input captions have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions text.
         */
        var applyFontColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleApplyFontColor? = null
        /**
         * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if present.
         */
        var backgroundColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleBackgroundColor? = null
        /**
         * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the background style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions.
         */
        var backgroundOpacity: kotlin.Int? = null
        /**
         * Specify the font that you want the service to use for your burn in captions when your input captions specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
         */
        var fallbackFont: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleFallbackFont? = null
        /**
         * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present.
         */
        var fontColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleFontColor? = null
        /**
         * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
         */
        var fontOpacity: kotlin.Int? = null
        /**
         * Specify the Font resolution (FontResolution) in DPI (dots per inch).
         */
        var fontResolution: kotlin.Int? = null
        /**
         * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
         */
        var fontScript: aws.sdk.kotlin.services.mediaconvert.model.FontScript? = null
        /**
         * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for automatic font size.
         */
        var fontSize: kotlin.Int? = null
        /**
         * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits, representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
         */
        var hexFontColor: kotlin.String? = null
        /**
         * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
         */
        var outlineColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleOutlineColor? = null
        /**
         * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present.
         */
        var outlineSize: kotlin.Int? = null
        /**
         * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
         */
        var shadowColor: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleShadowColor? = null
        /**
         * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass through the shadow style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all shadows from your output captions.
         */
        var shadowOpacity: kotlin.Int? = null
        /**
         * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
         */
        var shadowXOffset: kotlin.Int? = null
        /**
         * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present.
         */
        var shadowYOffset: kotlin.Int? = null
        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information from your input captions. MediaConvert uses default settings for any missing style and position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position information from your input captions and use default settings: white text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to manually override any of the individual style and position settings.
         */
        var stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.BurnInSubtitleStylePassthrough? = null
        /**
         * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
         */
        var teletextSpacing: aws.sdk.kotlin.services.mediaconvert.model.BurninSubtitleTeletextSpacing? = null
        /**
         * Specify the horizontal position (XPosition) of the captions, relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit x_position is provided, the horizontal caption position will be determined by the alignment parameter.
         */
        var xPosition: kotlin.Int? = null
        /**
         * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output.
         */
        var yPosition: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings) : this() {
            this.alignment = x.alignment
            this.applyFontColor = x.applyFontColor
            this.backgroundColor = x.backgroundColor
            this.backgroundOpacity = x.backgroundOpacity
            this.fallbackFont = x.fallbackFont
            this.fontColor = x.fontColor
            this.fontOpacity = x.fontOpacity
            this.fontResolution = x.fontResolution
            this.fontScript = x.fontScript
            this.fontSize = x.fontSize
            this.hexFontColor = x.hexFontColor
            this.outlineColor = x.outlineColor
            this.outlineSize = x.outlineSize
            this.shadowColor = x.shadowColor
            this.shadowOpacity = x.shadowOpacity
            this.shadowXOffset = x.shadowXOffset
            this.shadowYOffset = x.shadowYOffset
            this.stylePassthrough = x.stylePassthrough
            this.teletextSpacing = x.teletextSpacing
            this.xPosition = x.xPosition
            this.yPosition = x.yPosition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings = BurninDestinationSettings(this)
    }
}
