// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * This object holds groups of settings related to captions for one output. For each output that has captions, include one instance of CaptionDescriptions.
 */
class CaptionDescription private constructor(builder: Builder) {
    /**
     * Specifies which "Caption Selector":#inputs-caption_selector to use from each input when generating captions. The name should be of the format "Caption Selector <n>", which denotes that the Nth Caption Selector will be used from each input.
     */
    val captionSelectorName: kotlin.String? = builder.captionSelectorName
    /**
     * Specify the language for this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information when automatically selecting the font script for rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
     */
    val customLanguageCode: kotlin.String? = builder.customLanguageCode
    /**
     * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds to one output captions track. Depending on your output captions format, one tab might correspond to a set of output captions tracks. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
     */
    val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings? = builder.destinationSettings
    /**
     * Specify the language of this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information to choose the font language for rendering the captions text.
     */
    val languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = builder.languageCode
    /**
     * Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer's player device. For outputs in other output groups, the service ignores this setting.
     */
    val languageDescription: kotlin.String? = builder.languageDescription

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CaptionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CaptionDescription(")
        append("captionSelectorName=$captionSelectorName,")
        append("customLanguageCode=$customLanguageCode,")
        append("destinationSettings=$destinationSettings,")
        append("languageCode=$languageCode,")
        append("languageDescription=$languageDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = captionSelectorName?.hashCode() ?: 0
        result = 31 * result + (customLanguageCode?.hashCode() ?: 0)
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CaptionDescription

        if (captionSelectorName != other.captionSelectorName) return false
        if (customLanguageCode != other.customLanguageCode) return false
        if (destinationSettings != other.destinationSettings) return false
        if (languageCode != other.languageCode) return false
        if (languageDescription != other.languageDescription) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CaptionDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies which "Caption Selector":#inputs-caption_selector to use from each input when generating captions. The name should be of the format "Caption Selector <n>", which denotes that the Nth Caption Selector will be used from each input.
         */
        var captionSelectorName: kotlin.String? = null
        /**
         * Specify the language for this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information when automatically selecting the font script for rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
         */
        var customLanguageCode: kotlin.String? = null
        /**
         * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds to one output captions track. Depending on your output captions format, one tab might correspond to a set of output captions tracks. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
         */
        var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings? = null
        /**
         * Specify the language of this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information to choose the font language for rendering the captions text.
         */
        var languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = null
        /**
         * Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer's player device. For outputs in other output groups, the service ignores this setting.
         */
        var languageDescription: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CaptionDescription) : this() {
            this.captionSelectorName = x.captionSelectorName
            this.customLanguageCode = x.customLanguageCode
            this.destinationSettings = x.destinationSettings
            this.languageCode = x.languageCode
            this.languageDescription = x.languageDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CaptionDescription = CaptionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings] inside the given [block]
         */
        fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings.invoke(block)
        }
    }
}
