// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for CMAF encryption
 */
class CmafEncryptionSettings private constructor(builder: Builder) {
    /**
     * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.
     */
    val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * Specify the encryption scheme that you want the service to use when encrypting your CMAF segments. Choose AES-CBC subsample (SAMPLE-AES) or AES_CTR (AES-CTR).
     */
    val encryptionMethod: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionType? = builder.encryptionMethod
    /**
     * When you use DRM with CMAF outputs, choose whether the service writes the 128-bit encryption initialization vector in the HLS and DASH manifests.
     */
    val initializationVectorInManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafInitializationVectorInManifest? = builder.initializationVectorInManifest
    /**
     * If your output group type is CMAF, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is HLS, DASH, or Microsoft Smooth, use the SpekeKeyProvider settings instead.
     */
    val spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf? = builder.spekeKeyProvider
    /**
     * Use these settings to set up encryption with a static key provider.
     */
    val staticKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider? = builder.staticKeyProvider
    /**
     * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     */
    val type: aws.sdk.kotlin.services.mediaconvert.model.CmafKeyProviderType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmafEncryptionSettings(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("encryptionMethod=$encryptionMethod,")
        append("initializationVectorInManifest=$initializationVectorInManifest,")
        append("spekeKeyProvider=$spekeKeyProvider,")
        append("staticKeyProvider=$staticKeyProvider,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (encryptionMethod?.hashCode() ?: 0)
        result = 31 * result + (initializationVectorInManifest?.hashCode() ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        result = 31 * result + (staticKeyProvider?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmafEncryptionSettings

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (encryptionMethod != other.encryptionMethod) return false
        if (initializationVectorInManifest != other.initializationVectorInManifest) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false
        if (staticKeyProvider != other.staticKeyProvider) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.
         */
        var constantInitializationVector: kotlin.String? = null
        /**
         * Specify the encryption scheme that you want the service to use when encrypting your CMAF segments. Choose AES-CBC subsample (SAMPLE-AES) or AES_CTR (AES-CTR).
         */
        var encryptionMethod: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionType? = null
        /**
         * When you use DRM with CMAF outputs, choose whether the service writes the 128-bit encryption initialization vector in the HLS and DASH manifests.
         */
        var initializationVectorInManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafInitializationVectorInManifest? = null
        /**
         * If your output group type is CMAF, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is HLS, DASH, or Microsoft Smooth, use the SpekeKeyProvider settings instead.
         */
        var spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf? = null
        /**
         * Use these settings to set up encryption with a static key provider.
         */
        var staticKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider? = null
        /**
         * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         */
        var type: aws.sdk.kotlin.services.mediaconvert.model.CmafKeyProviderType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.encryptionMethod = x.encryptionMethod
            this.initializationVectorInManifest = x.initializationVectorInManifest
            this.spekeKeyProvider = x.spekeKeyProvider
            this.staticKeyProvider = x.staticKeyProvider
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings = CmafEncryptionSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf] inside the given [block]
         */
        fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider] inside the given [block]
         */
        fun staticKeyProvider(block: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider.Builder.() -> kotlin.Unit) {
            this.staticKeyProvider = aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider.invoke(block)
        }
    }
}
