// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to your CMAF output package. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job specification, include this object and any required children when you set Type, under OutputGroupSettings, to CMAF_GROUP_SETTINGS.
 */
class CmafGroupSettings private constructor(builder: Builder) {
    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each CMAF output group in your job. These default manifests reference every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     */
    val additionalManifests: List<CmafAdditionalManifest>? = builder.additionalManifests
    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.
     */
    val baseUrl: kotlin.String? = builder.baseUrl
    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control http header.
     */
    val clientCache: aws.sdk.kotlin.services.mediaconvert.model.CmafClientCache? = builder.clientCache
    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     */
    val codecSpecification: aws.sdk.kotlin.services.mediaconvert.model.CmafCodecSpecification? = builder.codecSpecification
    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * Settings associated with the destination. Will vary based on the type of destination
     */
    val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = builder.destinationSettings
    /**
     * DRM settings.
     */
    val encryption: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings? = builder.encryption
    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults to 2. Related setting: Use Fragment length control (FragmentLengthControl) to specify whether the encoder enforces this value strictly.
     */
    val fragmentLength: kotlin.Int? = builder.fragmentLength
    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS manifest (WriteHlsManifest), MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest. When you enable Write DASH manifest (WriteDashManifest), MediaConvert adds an entry in the .mpd manifest for each set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     */
    val imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlay? = builder.imageBasedTrickPlay
    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    val imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlaySettings? = builder.imageBasedTrickPlaySettings
    /**
     * When set to GZIP, compresses HLS playlist.
     */
    val manifestCompression: aws.sdk.kotlin.services.mediaconvert.model.CmafManifestCompression? = builder.manifestCompression
    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     */
    val manifestDurationFormat: aws.sdk.kotlin.services.mediaconvert.model.CmafManifestDurationFormat? = builder.manifestDurationFormat
    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     */
    val minBufferTime: kotlin.Int? = builder.minBufferTime
    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    val minFinalSegmentLength: kotlin.Double? = builder.minFinalSegmentLength
    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).
     */
    val mpdProfile: aws.sdk.kotlin.services.mediaconvert.model.CmafMpdProfile? = builder.mpdProfile
    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS (MATCH_INITIAL_PTS) when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based (ZERO_BASED) to have MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     */
    val ptsOffsetHandlingForBFrames: aws.sdk.kotlin.services.mediaconvert.model.CmafPtsOffsetHandlingForBFrames? = builder.ptsOffsetHandlingForBFrames
    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     */
    val segmentControl: aws.sdk.kotlin.services.mediaconvert.model.CmafSegmentControl? = builder.segmentControl
    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (CmafSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
     */
    val segmentLength: kotlin.Int? = builder.segmentLength
    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    val segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.CmafSegmentLengthControl? = builder.segmentLengthControl
    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     */
    val streamInfResolution: aws.sdk.kotlin.services.mediaconvert.model.CmafStreamInfResolution? = builder.streamInfResolution
    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual duration of the segment. Some older players may experience interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     */
    val targetDurationCompatibilityMode: aws.sdk.kotlin.services.mediaconvert.model.CmafTargetDurationCompatibilityMode? = builder.targetDurationCompatibilityMode
    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     */
    val writeDashManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteDashManifest? = builder.writeDashManifest
    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     */
    val writeHlsManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteHlsManifest? = builder.writeHlsManifest
    /**
     * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     */
    val writeSegmentTimelineInRepresentation: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteSegmentTimelineInRepresentation? = builder.writeSegmentTimelineInRepresentation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CmafGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmafGroupSettings(")
        append("additionalManifests=$additionalManifests,")
        append("baseUrl=$baseUrl,")
        append("clientCache=$clientCache,")
        append("codecSpecification=$codecSpecification,")
        append("destination=$destination,")
        append("destinationSettings=$destinationSettings,")
        append("encryption=$encryption,")
        append("fragmentLength=$fragmentLength,")
        append("imageBasedTrickPlay=$imageBasedTrickPlay,")
        append("imageBasedTrickPlaySettings=$imageBasedTrickPlaySettings,")
        append("manifestCompression=$manifestCompression,")
        append("manifestDurationFormat=$manifestDurationFormat,")
        append("minBufferTime=$minBufferTime,")
        append("minFinalSegmentLength=$minFinalSegmentLength,")
        append("mpdProfile=$mpdProfile,")
        append("ptsOffsetHandlingForBFrames=$ptsOffsetHandlingForBFrames,")
        append("segmentControl=$segmentControl,")
        append("segmentLength=$segmentLength,")
        append("segmentLengthControl=$segmentLengthControl,")
        append("streamInfResolution=$streamInfResolution,")
        append("targetDurationCompatibilityMode=$targetDurationCompatibilityMode,")
        append("writeDashManifest=$writeDashManifest,")
        append("writeHlsManifest=$writeHlsManifest,")
        append("writeSegmentTimelineInRepresentation=$writeSegmentTimelineInRepresentation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalManifests?.hashCode() ?: 0
        result = 31 * result + (baseUrl?.hashCode() ?: 0)
        result = 31 * result + (clientCache?.hashCode() ?: 0)
        result = 31 * result + (codecSpecification?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (fragmentLength ?: 0)
        result = 31 * result + (imageBasedTrickPlay?.hashCode() ?: 0)
        result = 31 * result + (imageBasedTrickPlaySettings?.hashCode() ?: 0)
        result = 31 * result + (manifestCompression?.hashCode() ?: 0)
        result = 31 * result + (manifestDurationFormat?.hashCode() ?: 0)
        result = 31 * result + (minBufferTime ?: 0)
        result = 31 * result + (minFinalSegmentLength?.hashCode() ?: 0)
        result = 31 * result + (mpdProfile?.hashCode() ?: 0)
        result = 31 * result + (ptsOffsetHandlingForBFrames?.hashCode() ?: 0)
        result = 31 * result + (segmentControl?.hashCode() ?: 0)
        result = 31 * result + (segmentLength ?: 0)
        result = 31 * result + (segmentLengthControl?.hashCode() ?: 0)
        result = 31 * result + (streamInfResolution?.hashCode() ?: 0)
        result = 31 * result + (targetDurationCompatibilityMode?.hashCode() ?: 0)
        result = 31 * result + (writeDashManifest?.hashCode() ?: 0)
        result = 31 * result + (writeHlsManifest?.hashCode() ?: 0)
        result = 31 * result + (writeSegmentTimelineInRepresentation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmafGroupSettings

        if (additionalManifests != other.additionalManifests) return false
        if (baseUrl != other.baseUrl) return false
        if (clientCache != other.clientCache) return false
        if (codecSpecification != other.codecSpecification) return false
        if (destination != other.destination) return false
        if (destinationSettings != other.destinationSettings) return false
        if (encryption != other.encryption) return false
        if (fragmentLength != other.fragmentLength) return false
        if (imageBasedTrickPlay != other.imageBasedTrickPlay) return false
        if (imageBasedTrickPlaySettings != other.imageBasedTrickPlaySettings) return false
        if (manifestCompression != other.manifestCompression) return false
        if (manifestDurationFormat != other.manifestDurationFormat) return false
        if (minBufferTime != other.minBufferTime) return false
        if (minFinalSegmentLength != other.minFinalSegmentLength) return false
        if (mpdProfile != other.mpdProfile) return false
        if (ptsOffsetHandlingForBFrames != other.ptsOffsetHandlingForBFrames) return false
        if (segmentControl != other.segmentControl) return false
        if (segmentLength != other.segmentLength) return false
        if (segmentLengthControl != other.segmentLengthControl) return false
        if (streamInfResolution != other.streamInfResolution) return false
        if (targetDurationCompatibilityMode != other.targetDurationCompatibilityMode) return false
        if (writeDashManifest != other.writeDashManifest) return false
        if (writeHlsManifest != other.writeHlsManifest) return false
        if (writeSegmentTimelineInRepresentation != other.writeSegmentTimelineInRepresentation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CmafGroupSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each CMAF output group in your job. These default manifests reference every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
         */
        var additionalManifests: List<CmafAdditionalManifest>? = null
        /**
         * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.
         */
        var baseUrl: kotlin.String? = null
        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control http header.
         */
        var clientCache: aws.sdk.kotlin.services.mediaconvert.model.CmafClientCache? = null
        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         */
        var codecSpecification: aws.sdk.kotlin.services.mediaconvert.model.CmafCodecSpecification? = null
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
         */
        var destination: kotlin.String? = null
        /**
         * Settings associated with the destination. Will vary based on the type of destination
         */
        var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = null
        /**
         * DRM settings.
         */
        var encryption: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings? = null
        /**
         * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults to 2. Related setting: Use Fragment length control (FragmentLengthControl) to specify whether the encoder enforces this value strictly.
         */
        var fragmentLength: kotlin.Int? = null
        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS manifest (WriteHlsManifest), MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest. When you enable Write DASH manifest (WriteDashManifest), MediaConvert adds an entry in the .mpd manifest for each set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         */
        var imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlay? = null
        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         */
        var imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlaySettings? = null
        /**
         * When set to GZIP, compresses HLS playlist.
         */
        var manifestCompression: aws.sdk.kotlin.services.mediaconvert.model.CmafManifestCompression? = null
        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         */
        var manifestDurationFormat: aws.sdk.kotlin.services.mediaconvert.model.CmafManifestDurationFormat? = null
        /**
         * Minimum time of initially buffered media that is needed to ensure smooth playout.
         */
        var minBufferTime: kotlin.Int? = null
        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         */
        var minFinalSegmentLength: kotlin.Double? = null
        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).
         */
        var mpdProfile: aws.sdk.kotlin.services.mediaconvert.model.CmafMpdProfile? = null
        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS (MATCH_INITIAL_PTS) when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based (ZERO_BASED) to have MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
         */
        var ptsOffsetHandlingForBFrames: aws.sdk.kotlin.services.mediaconvert.model.CmafPtsOffsetHandlingForBFrames? = null
        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         */
        var segmentControl: aws.sdk.kotlin.services.mediaconvert.model.CmafSegmentControl? = null
        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (CmafSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
         */
        var segmentLength: kotlin.Int? = null
        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
         */
        var segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.CmafSegmentLengthControl? = null
        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         */
        var streamInfResolution: aws.sdk.kotlin.services.mediaconvert.model.CmafStreamInfResolution? = null
        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual duration of the segment. Some older players may experience interrupted playback when the actual duration of a track in a segment is longer than the target duration.
         */
        var targetDurationCompatibilityMode: aws.sdk.kotlin.services.mediaconvert.model.CmafTargetDurationCompatibilityMode? = null
        /**
         * When set to ENABLED, a DASH MPD manifest will be generated for this output.
         */
        var writeDashManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteDashManifest? = null
        /**
         * When set to ENABLED, an Apple HLS manifest will be generated for this output.
         */
        var writeHlsManifest: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteHlsManifest? = null
        /**
         * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
         */
        var writeSegmentTimelineInRepresentation: aws.sdk.kotlin.services.mediaconvert.model.CmafWriteSegmentTimelineInRepresentation? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CmafGroupSettings) : this() {
            this.additionalManifests = x.additionalManifests
            this.baseUrl = x.baseUrl
            this.clientCache = x.clientCache
            this.codecSpecification = x.codecSpecification
            this.destination = x.destination
            this.destinationSettings = x.destinationSettings
            this.encryption = x.encryption
            this.fragmentLength = x.fragmentLength
            this.imageBasedTrickPlay = x.imageBasedTrickPlay
            this.imageBasedTrickPlaySettings = x.imageBasedTrickPlaySettings
            this.manifestCompression = x.manifestCompression
            this.manifestDurationFormat = x.manifestDurationFormat
            this.minBufferTime = x.minBufferTime
            this.minFinalSegmentLength = x.minFinalSegmentLength
            this.mpdProfile = x.mpdProfile
            this.ptsOffsetHandlingForBFrames = x.ptsOffsetHandlingForBFrames
            this.segmentControl = x.segmentControl
            this.segmentLength = x.segmentLength
            this.segmentLengthControl = x.segmentLengthControl
            this.streamInfResolution = x.streamInfResolution
            this.targetDurationCompatibilityMode = x.targetDurationCompatibilityMode
            this.writeDashManifest = x.writeDashManifest
            this.writeHlsManifest = x.writeHlsManifest
            this.writeSegmentTimelineInRepresentation = x.writeSegmentTimelineInRepresentation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CmafGroupSettings = CmafGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings] inside the given [block]
         */
        fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconvert.model.CmafEncryptionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlaySettings] inside the given [block]
         */
        fun imageBasedTrickPlaySettings(block: aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlaySettings.Builder.() -> kotlin.Unit) {
            this.imageBasedTrickPlaySettings = aws.sdk.kotlin.services.mediaconvert.model.CmafImageBasedTrickPlaySettings.invoke(block)
        }
    }
}
