// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use these settings to insert a DVB Service Description Table (SDT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
 */
class DvbSdtSettings private constructor(builder: Builder) {
    /**
     * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT information.
     */
    val outputSdt: aws.sdk.kotlin.services.mediaconvert.model.OutputSdt? = builder.outputSdt
    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     */
    val sdtInterval: kotlin.Int? = builder.sdtInterval
    /**
     * The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.
     */
    val serviceName: kotlin.String? = builder.serviceName
    /**
     * The service provider name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.
     */
    val serviceProviderName: kotlin.String? = builder.serviceProviderName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DvbSdtSettings(")
        append("outputSdt=$outputSdt,")
        append("sdtInterval=$sdtInterval,")
        append("serviceName=$serviceName,")
        append("serviceProviderName=$serviceProviderName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = outputSdt?.hashCode() ?: 0
        result = 31 * result + (sdtInterval ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceProviderName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DvbSdtSettings

        if (outputSdt != other.outputSdt) return false
        if (sdtInterval != other.sdtInterval) return false
        if (serviceName != other.serviceName) return false
        if (serviceProviderName != other.serviceProviderName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT information.
         */
        var outputSdt: aws.sdk.kotlin.services.mediaconvert.model.OutputSdt? = null
        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        var sdtInterval: kotlin.Int? = null
        /**
         * The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.
         */
        var serviceName: kotlin.String? = null
        /**
         * The service provider name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.
         */
        var serviceProviderName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings) : this() {
            this.outputSdt = x.outputSdt
            this.sdtInterval = x.sdtInterval
            this.serviceName = x.serviceName
            this.serviceProviderName = x.serviceProviderName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings = DvbSdtSettings(this)
    }
}
