// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to DVB_SUB.
 */
class DvbSubDestinationSettings private constructor(builder: Builder) {
    /**
     * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val alignment: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleAlignment? = builder.alignment
    /**
     * Ignore this setting unless Style Passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies to white text in your input captions. For example, if your font color setting is Yellow, and your input captions have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions text.
     */
    val applyFontColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleApplyFontColor? = builder.applyFontColor
    /**
     * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if present.
     */
    val backgroundColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleBackgroundColor? = builder.backgroundColor
    /**
     * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the background style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val backgroundOpacity: kotlin.Int? = builder.backgroundOpacity
    /**
     * Specify how MediaConvert handles the display definition segment (DDS). Keep the default, None (NONE), to exclude the DDS from this set of captions. Choose No display window (NO_DISPLAY_WINDOW) to have MediaConvert include the DDS but not include display window data. In this case, MediaConvert writes that information to the page composition segment (PCS) instead. Choose Specify (SPECIFIED) to have MediaConvert set up the display window based on the values that you specify in related job settings. For video resolutions that are 576 pixels or smaller in height, MediaConvert doesn't include the DDS, regardless of the value you choose for DDS handling (ddsHandling). In this case, it doesn't write the display window data to the PCS either. Related settings: Use the settings DDS x-coordinate (ddsXCoordinate) and DDS y-coordinate (ddsYCoordinate) to specify the offset between the top left corner of the display window and the top left corner of the video frame. All burn-in and DVB-Sub font settings must match.
     */
    val ddsHandling: aws.sdk.kotlin.services.mediaconvert.model.DvbddsHandling? = builder.ddsHandling
    /**
     * Use this setting, along with DDS y-coordinate (ddsYCoordinate), to specify the upper left corner of the display definition segment (DDS) display window. With this setting, specify the distance, in pixels, between the left side of the frame and the left side of the DDS display window. Keep the default value, 0, to have MediaConvert automatically choose this offset. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). MediaConvert uses these values to determine whether to write page position data to the DDS or to the page composition segment (PCS). All burn-in and DVB-Sub font settings must match.
     */
    val ddsXCoordinate: kotlin.Int? = builder.ddsXCoordinate
    /**
     * Use this setting, along with DDS x-coordinate (ddsXCoordinate), to specify the upper left corner of the display definition segment (DDS) display window. With this setting, specify the distance, in pixels, between the top of the frame and the top of the DDS display window. Keep the default value, 0, to have MediaConvert automatically choose this offset. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). MediaConvert uses these values to determine whether to write page position data to the DDS or to the page composition segment (PCS). All burn-in and DVB-Sub font settings must match.
     */
    val ddsYCoordinate: kotlin.Int? = builder.ddsYCoordinate
    /**
     * Specify the font that you want the service to use for your burn in captions when your input captions specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
     */
    val fallbackFont: aws.sdk.kotlin.services.mediaconvert.model.DvbSubSubtitleFallbackFont? = builder.fallbackFont
    /**
     * Specify the color of the captions text. Leave Font color (FontColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val fontColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleFontColor? = builder.fontColor
    /**
     * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val fontOpacity: kotlin.Int? = builder.fontOpacity
    /**
     * Specify the Font resolution (FontResolution) in DPI (dots per inch). Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val fontResolution: kotlin.Int? = builder.fontResolution
    /**
     * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val fontScript: aws.sdk.kotlin.services.mediaconvert.model.FontScript? = builder.fontScript
    /**
     * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for automatic font size. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val fontSize: kotlin.Int? = builder.fontSize
    /**
     * Specify the height, in pixels, of this set of DVB-Sub captions. The default value is 576 pixels. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). All burn-in and DVB-Sub font settings must match.
     */
    val height: kotlin.Int? = builder.height
    /**
     * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits, representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
     */
    val hexFontColor: kotlin.String? = builder.hexFontColor
    /**
     * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font outline color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val outlineColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleOutlineColor? = builder.outlineColor
    /**
     * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val outlineSize: kotlin.Int? = builder.outlineSize
    /**
     * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val shadowColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleShadowColor? = builder.shadowColor
    /**
     * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass through the shadow style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all shadows from your output captions. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val shadowOpacity: kotlin.Int? = builder.shadowOpacity
    /**
     * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val shadowXOffset: kotlin.Int? = builder.shadowXOffset
    /**
     * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val shadowYOffset: kotlin.Int? = builder.shadowYOffset
    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information from your input captions. MediaConvert uses default settings for any missing style and position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position information from your input captions and use default settings: white text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to manually override any of the individual style and position settings.
     */
    val stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleStylePassthrough? = builder.stylePassthrough
    /**
     * Specify whether your DVB subtitles are standard or for hearing impaired. Choose hearing impaired if your subtitles include audio descriptions and dialogue. Choose standard if your subtitles include only dialogue.
     */
    val subtitlingType: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitlingType? = builder.subtitlingType
    /**
     * Specify whether the Text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val teletextSpacing: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleTeletextSpacing? = builder.teletextSpacing
    /**
     * Specify the width, in pixels, of this set of DVB-Sub captions. The default value is 720 pixels. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). All burn-in and DVB-Sub font settings must match.
     */
    val width: kotlin.Int? = builder.width
    /**
     * Specify the horizontal position (XPosition) of the captions, relative to the left side of the outputin pixels. A value of 10 would result in the captions starting 10 pixels from the left ofthe output. If no explicit x_position is provided, the horizontal caption position will bedetermined by the alignment parameter. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val xPosition: kotlin.Int? = builder.xPosition
    /**
     * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output. Within your job settings, all of your DVB-Sub settings must be identical.
     */
    val yPosition: kotlin.Int? = builder.yPosition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DvbSubDestinationSettings(")
        append("alignment=$alignment,")
        append("applyFontColor=$applyFontColor,")
        append("backgroundColor=$backgroundColor,")
        append("backgroundOpacity=$backgroundOpacity,")
        append("ddsHandling=$ddsHandling,")
        append("ddsXCoordinate=$ddsXCoordinate,")
        append("ddsYCoordinate=$ddsYCoordinate,")
        append("fallbackFont=$fallbackFont,")
        append("fontColor=$fontColor,")
        append("fontOpacity=$fontOpacity,")
        append("fontResolution=$fontResolution,")
        append("fontScript=$fontScript,")
        append("fontSize=$fontSize,")
        append("height=$height,")
        append("hexFontColor=$hexFontColor,")
        append("outlineColor=$outlineColor,")
        append("outlineSize=$outlineSize,")
        append("shadowColor=$shadowColor,")
        append("shadowOpacity=$shadowOpacity,")
        append("shadowXOffset=$shadowXOffset,")
        append("shadowYOffset=$shadowYOffset,")
        append("stylePassthrough=$stylePassthrough,")
        append("subtitlingType=$subtitlingType,")
        append("teletextSpacing=$teletextSpacing,")
        append("width=$width,")
        append("xPosition=$xPosition,")
        append("yPosition=$yPosition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alignment?.hashCode() ?: 0
        result = 31 * result + (applyFontColor?.hashCode() ?: 0)
        result = 31 * result + (backgroundColor?.hashCode() ?: 0)
        result = 31 * result + (backgroundOpacity ?: 0)
        result = 31 * result + (ddsHandling?.hashCode() ?: 0)
        result = 31 * result + (ddsXCoordinate ?: 0)
        result = 31 * result + (ddsYCoordinate ?: 0)
        result = 31 * result + (fallbackFont?.hashCode() ?: 0)
        result = 31 * result + (fontColor?.hashCode() ?: 0)
        result = 31 * result + (fontOpacity ?: 0)
        result = 31 * result + (fontResolution ?: 0)
        result = 31 * result + (fontScript?.hashCode() ?: 0)
        result = 31 * result + (fontSize ?: 0)
        result = 31 * result + (height ?: 0)
        result = 31 * result + (hexFontColor?.hashCode() ?: 0)
        result = 31 * result + (outlineColor?.hashCode() ?: 0)
        result = 31 * result + (outlineSize ?: 0)
        result = 31 * result + (shadowColor?.hashCode() ?: 0)
        result = 31 * result + (shadowOpacity ?: 0)
        result = 31 * result + (shadowXOffset ?: 0)
        result = 31 * result + (shadowYOffset ?: 0)
        result = 31 * result + (stylePassthrough?.hashCode() ?: 0)
        result = 31 * result + (subtitlingType?.hashCode() ?: 0)
        result = 31 * result + (teletextSpacing?.hashCode() ?: 0)
        result = 31 * result + (width ?: 0)
        result = 31 * result + (xPosition ?: 0)
        result = 31 * result + (yPosition ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DvbSubDestinationSettings

        if (alignment != other.alignment) return false
        if (applyFontColor != other.applyFontColor) return false
        if (backgroundColor != other.backgroundColor) return false
        if (backgroundOpacity != other.backgroundOpacity) return false
        if (ddsHandling != other.ddsHandling) return false
        if (ddsXCoordinate != other.ddsXCoordinate) return false
        if (ddsYCoordinate != other.ddsYCoordinate) return false
        if (fallbackFont != other.fallbackFont) return false
        if (fontColor != other.fontColor) return false
        if (fontOpacity != other.fontOpacity) return false
        if (fontResolution != other.fontResolution) return false
        if (fontScript != other.fontScript) return false
        if (fontSize != other.fontSize) return false
        if (height != other.height) return false
        if (hexFontColor != other.hexFontColor) return false
        if (outlineColor != other.outlineColor) return false
        if (outlineSize != other.outlineSize) return false
        if (shadowColor != other.shadowColor) return false
        if (shadowOpacity != other.shadowOpacity) return false
        if (shadowXOffset != other.shadowXOffset) return false
        if (shadowYOffset != other.shadowYOffset) return false
        if (stylePassthrough != other.stylePassthrough) return false
        if (subtitlingType != other.subtitlingType) return false
        if (teletextSpacing != other.teletextSpacing) return false
        if (width != other.width) return false
        if (xPosition != other.xPosition) return false
        if (yPosition != other.yPosition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var alignment: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleAlignment? = null
        /**
         * Ignore this setting unless Style Passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies to white text in your input captions. For example, if your font color setting is Yellow, and your input captions have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions text.
         */
        var applyFontColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleApplyFontColor? = null
        /**
         * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if present.
         */
        var backgroundColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleBackgroundColor? = null
        /**
         * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the background style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var backgroundOpacity: kotlin.Int? = null
        /**
         * Specify how MediaConvert handles the display definition segment (DDS). Keep the default, None (NONE), to exclude the DDS from this set of captions. Choose No display window (NO_DISPLAY_WINDOW) to have MediaConvert include the DDS but not include display window data. In this case, MediaConvert writes that information to the page composition segment (PCS) instead. Choose Specify (SPECIFIED) to have MediaConvert set up the display window based on the values that you specify in related job settings. For video resolutions that are 576 pixels or smaller in height, MediaConvert doesn't include the DDS, regardless of the value you choose for DDS handling (ddsHandling). In this case, it doesn't write the display window data to the PCS either. Related settings: Use the settings DDS x-coordinate (ddsXCoordinate) and DDS y-coordinate (ddsYCoordinate) to specify the offset between the top left corner of the display window and the top left corner of the video frame. All burn-in and DVB-Sub font settings must match.
         */
        var ddsHandling: aws.sdk.kotlin.services.mediaconvert.model.DvbddsHandling? = null
        /**
         * Use this setting, along with DDS y-coordinate (ddsYCoordinate), to specify the upper left corner of the display definition segment (DDS) display window. With this setting, specify the distance, in pixels, between the left side of the frame and the left side of the DDS display window. Keep the default value, 0, to have MediaConvert automatically choose this offset. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). MediaConvert uses these values to determine whether to write page position data to the DDS or to the page composition segment (PCS). All burn-in and DVB-Sub font settings must match.
         */
        var ddsXCoordinate: kotlin.Int? = null
        /**
         * Use this setting, along with DDS x-coordinate (ddsXCoordinate), to specify the upper left corner of the display definition segment (DDS) display window. With this setting, specify the distance, in pixels, between the top of the frame and the top of the DDS display window. Keep the default value, 0, to have MediaConvert automatically choose this offset. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). MediaConvert uses these values to determine whether to write page position data to the DDS or to the page composition segment (PCS). All burn-in and DVB-Sub font settings must match.
         */
        var ddsYCoordinate: kotlin.Int? = null
        /**
         * Specify the font that you want the service to use for your burn in captions when your input captions specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
         */
        var fallbackFont: aws.sdk.kotlin.services.mediaconvert.model.DvbSubSubtitleFallbackFont? = null
        /**
         * Specify the color of the captions text. Leave Font color (FontColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var fontColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleFontColor? = null
        /**
         * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var fontOpacity: kotlin.Int? = null
        /**
         * Specify the Font resolution (FontResolution) in DPI (dots per inch). Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var fontResolution: kotlin.Int? = null
        /**
         * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var fontScript: aws.sdk.kotlin.services.mediaconvert.model.FontScript? = null
        /**
         * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for automatic font size. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var fontSize: kotlin.Int? = null
        /**
         * Specify the height, in pixels, of this set of DVB-Sub captions. The default value is 576 pixels. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). All burn-in and DVB-Sub font settings must match.
         */
        var height: kotlin.Int? = null
        /**
         * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits, representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
         */
        var hexFontColor: kotlin.String? = null
        /**
         * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough) to enabled to use the font outline color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var outlineColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleOutlineColor? = null
        /**
         * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var outlineSize: kotlin.Int? = null
        /**
         * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var shadowColor: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleShadowColor? = null
        /**
         * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass through the shadow style information in your input captions to your output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove all shadows from your output captions. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var shadowOpacity: kotlin.Int? = null
        /**
         * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var shadowXOffset: kotlin.Int? = null
        /**
         * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var shadowYOffset: kotlin.Int? = null
        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information from your input captions. MediaConvert uses default settings for any missing style and position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position information from your input captions and use default settings: white text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to manually override any of the individual style and position settings.
         */
        var stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleStylePassthrough? = null
        /**
         * Specify whether your DVB subtitles are standard or for hearing impaired. Choose hearing impaired if your subtitles include audio descriptions and dialogue. Choose standard if your subtitles include only dialogue.
         */
        var subtitlingType: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitlingType? = null
        /**
         * Specify whether the Text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var teletextSpacing: aws.sdk.kotlin.services.mediaconvert.model.DvbSubtitleTeletextSpacing? = null
        /**
         * Specify the width, in pixels, of this set of DVB-Sub captions. The default value is 720 pixels. Related setting: When you use this setting, you must set DDS handling (ddsHandling) to a value other than None (NONE). All burn-in and DVB-Sub font settings must match.
         */
        var width: kotlin.Int? = null
        /**
         * Specify the horizontal position (XPosition) of the captions, relative to the left side of the outputin pixels. A value of 10 would result in the captions starting 10 pixels from the left ofthe output. If no explicit x_position is provided, the horizontal caption position will bedetermined by the alignment parameter. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var xPosition: kotlin.Int? = null
        /**
         * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output. Within your job settings, all of your DVB-Sub settings must be identical.
         */
        var yPosition: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings) : this() {
            this.alignment = x.alignment
            this.applyFontColor = x.applyFontColor
            this.backgroundColor = x.backgroundColor
            this.backgroundOpacity = x.backgroundOpacity
            this.ddsHandling = x.ddsHandling
            this.ddsXCoordinate = x.ddsXCoordinate
            this.ddsYCoordinate = x.ddsYCoordinate
            this.fallbackFont = x.fallbackFont
            this.fontColor = x.fontColor
            this.fontOpacity = x.fontOpacity
            this.fontResolution = x.fontResolution
            this.fontScript = x.fontScript
            this.fontSize = x.fontSize
            this.height = x.height
            this.hexFontColor = x.hexFontColor
            this.outlineColor = x.outlineColor
            this.outlineSize = x.outlineSize
            this.shadowColor = x.shadowColor
            this.shadowOpacity = x.shadowOpacity
            this.shadowXOffset = x.shadowXOffset
            this.shadowYOffset = x.shadowYOffset
            this.stylePassthrough = x.stylePassthrough
            this.subtitlingType = x.subtitlingType
            this.teletextSpacing = x.teletextSpacing
            this.width = x.width
            this.xPosition = x.xPosition
            this.yPosition = x.yPosition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings = DvbSubDestinationSettings(this)
    }
}
