// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
 */
class Eac3Settings private constructor(builder: Builder) {
    /**
     * If set to ATTENUATE_3_DB, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
     */
    val attenuationControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AttenuationControl? = builder.attenuationControl
    /**
     * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     */
    val bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3BitstreamMode? = builder.bitstreamMode
    /**
     * Dolby Digital Plus coding mode. Determines number of channels.
     */
    val codingMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3CodingMode? = builder.codingMode
    /**
     * Activates a DC highpass filter for all input channels.
     */
    val dcFilter: aws.sdk.kotlin.services.mediaconvert.model.Eac3DcFilter? = builder.dcFilter
    /**
     * Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed through.
     */
    val dialnorm: kotlin.Int? = builder.dialnorm
    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    val dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Eac3DynamicRangeCompressionLine? = builder.dynamicRangeCompressionLine
    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    val dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Eac3DynamicRangeCompressionRf? = builder.dynamicRangeCompressionRf
    /**
     * When encoding 3/2 audio, controls whether the LFE channel is enabled
     */
    val lfeControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3LfeControl? = builder.lfeControl
    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     */
    val lfeFilter: aws.sdk.kotlin.services.mediaconvert.model.Eac3LfeFilter? = builder.lfeFilter
    /**
     * Specify a value for the following Dolby Digital Plus setting: Left only/Right only center mix (Lo/Ro center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only center (loRoCenterMixLevel).
     */
    val loRoCenterMixLevel: kotlin.Double? = builder.loRoCenterMixLevel
    /**
     * Specify a value for the following Dolby Digital Plus setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only surround (loRoSurroundMixLevel).
     */
    val loRoSurroundMixLevel: kotlin.Double? = builder.loRoSurroundMixLevel
    /**
     * Specify a value for the following Dolby Digital Plus setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total center (ltRtCenterMixLevel).
     */
    val ltRtCenterMixLevel: kotlin.Double? = builder.ltRtCenterMixLevel
    /**
     * Specify a value for the following Dolby Digital Plus setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total surround (ltRtSurroundMixLevel).
     */
    val ltRtSurroundMixLevel: kotlin.Double? = builder.ltRtSurroundMixLevel
    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     */
    val metadataControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3MetadataControl? = builder.metadataControl
    /**
     * When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is present on the input. this detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
     */
    val passthroughControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3PassthroughControl? = builder.passthroughControl
    /**
     * Controls the amount of phase-shift applied to the surround channels. Only used for 3/2 coding mode.
     */
    val phaseControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3PhaseControl? = builder.phaseControl
    /**
     * This value is always 48000. It represents the sample rate in Hz.
     */
    val sampleRate: kotlin.Int? = builder.sampleRate
    /**
     * Choose how the service does stereo downmixing. This setting only applies if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Stereo downmix (Eac3StereoDownmix).
     */
    val stereoDownmix: aws.sdk.kotlin.services.mediaconvert.model.Eac3StereoDownmix? = builder.stereoDownmix
    /**
     * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
     */
    val surroundExMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3SurroundExMode? = builder.surroundExMode
    /**
     * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
     */
    val surroundMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3SurroundMode? = builder.surroundMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Eac3Settings(")
        append("attenuationControl=$attenuationControl,")
        append("bitrate=$bitrate,")
        append("bitstreamMode=$bitstreamMode,")
        append("codingMode=$codingMode,")
        append("dcFilter=$dcFilter,")
        append("dialnorm=$dialnorm,")
        append("dynamicRangeCompressionLine=$dynamicRangeCompressionLine,")
        append("dynamicRangeCompressionRf=$dynamicRangeCompressionRf,")
        append("lfeControl=$lfeControl,")
        append("lfeFilter=$lfeFilter,")
        append("loRoCenterMixLevel=$loRoCenterMixLevel,")
        append("loRoSurroundMixLevel=$loRoSurroundMixLevel,")
        append("ltRtCenterMixLevel=$ltRtCenterMixLevel,")
        append("ltRtSurroundMixLevel=$ltRtSurroundMixLevel,")
        append("metadataControl=$metadataControl,")
        append("passthroughControl=$passthroughControl,")
        append("phaseControl=$phaseControl,")
        append("sampleRate=$sampleRate,")
        append("stereoDownmix=$stereoDownmix,")
        append("surroundExMode=$surroundExMode,")
        append("surroundMode=$surroundMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attenuationControl?.hashCode() ?: 0
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (bitstreamMode?.hashCode() ?: 0)
        result = 31 * result + (codingMode?.hashCode() ?: 0)
        result = 31 * result + (dcFilter?.hashCode() ?: 0)
        result = 31 * result + (dialnorm ?: 0)
        result = 31 * result + (dynamicRangeCompressionLine?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeCompressionRf?.hashCode() ?: 0)
        result = 31 * result + (lfeControl?.hashCode() ?: 0)
        result = 31 * result + (lfeFilter?.hashCode() ?: 0)
        result = 31 * result + (loRoCenterMixLevel?.hashCode() ?: 0)
        result = 31 * result + (loRoSurroundMixLevel?.hashCode() ?: 0)
        result = 31 * result + (ltRtCenterMixLevel?.hashCode() ?: 0)
        result = 31 * result + (ltRtSurroundMixLevel?.hashCode() ?: 0)
        result = 31 * result + (metadataControl?.hashCode() ?: 0)
        result = 31 * result + (passthroughControl?.hashCode() ?: 0)
        result = 31 * result + (phaseControl?.hashCode() ?: 0)
        result = 31 * result + (sampleRate ?: 0)
        result = 31 * result + (stereoDownmix?.hashCode() ?: 0)
        result = 31 * result + (surroundExMode?.hashCode() ?: 0)
        result = 31 * result + (surroundMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Eac3Settings

        if (attenuationControl != other.attenuationControl) return false
        if (bitrate != other.bitrate) return false
        if (bitstreamMode != other.bitstreamMode) return false
        if (codingMode != other.codingMode) return false
        if (dcFilter != other.dcFilter) return false
        if (dialnorm != other.dialnorm) return false
        if (dynamicRangeCompressionLine != other.dynamicRangeCompressionLine) return false
        if (dynamicRangeCompressionRf != other.dynamicRangeCompressionRf) return false
        if (lfeControl != other.lfeControl) return false
        if (lfeFilter != other.lfeFilter) return false
        if (loRoCenterMixLevel != other.loRoCenterMixLevel) return false
        if (loRoSurroundMixLevel != other.loRoSurroundMixLevel) return false
        if (ltRtCenterMixLevel != other.ltRtCenterMixLevel) return false
        if (ltRtSurroundMixLevel != other.ltRtSurroundMixLevel) return false
        if (metadataControl != other.metadataControl) return false
        if (passthroughControl != other.passthroughControl) return false
        if (phaseControl != other.phaseControl) return false
        if (sampleRate != other.sampleRate) return false
        if (stereoDownmix != other.stereoDownmix) return false
        if (surroundExMode != other.surroundExMode) return false
        if (surroundMode != other.surroundMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * If set to ATTENUATE_3_DB, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
         */
        var attenuationControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AttenuationControl? = null
        /**
         * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         */
        var bitrate: kotlin.Int? = null
        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         */
        var bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3BitstreamMode? = null
        /**
         * Dolby Digital Plus coding mode. Determines number of channels.
         */
        var codingMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3CodingMode? = null
        /**
         * Activates a DC highpass filter for all input channels.
         */
        var dcFilter: aws.sdk.kotlin.services.mediaconvert.model.Eac3DcFilter? = null
        /**
         * Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed through.
         */
        var dialnorm: kotlin.Int? = null
        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        var dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Eac3DynamicRangeCompressionLine? = null
        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        var dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Eac3DynamicRangeCompressionRf? = null
        /**
         * When encoding 3/2 audio, controls whether the LFE channel is enabled
         */
        var lfeControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3LfeControl? = null
        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         */
        var lfeFilter: aws.sdk.kotlin.services.mediaconvert.model.Eac3LfeFilter? = null
        /**
         * Specify a value for the following Dolby Digital Plus setting: Left only/Right only center mix (Lo/Ro center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only center (loRoCenterMixLevel).
         */
        var loRoCenterMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Digital Plus setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only surround (loRoSurroundMixLevel).
         */
        var loRoSurroundMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Digital Plus setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total center (ltRtCenterMixLevel).
         */
        var ltRtCenterMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Digital Plus setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total surround (ltRtSurroundMixLevel).
         */
        var ltRtSurroundMixLevel: kotlin.Double? = null
        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
         */
        var metadataControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3MetadataControl? = null
        /**
         * When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is present on the input. this detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
         */
        var passthroughControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3PassthroughControl? = null
        /**
         * Controls the amount of phase-shift applied to the surround channels. Only used for 3/2 coding mode.
         */
        var phaseControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3PhaseControl? = null
        /**
         * This value is always 48000. It represents the sample rate in Hz.
         */
        var sampleRate: kotlin.Int? = null
        /**
         * Choose how the service does stereo downmixing. This setting only applies if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Stereo downmix (Eac3StereoDownmix).
         */
        var stereoDownmix: aws.sdk.kotlin.services.mediaconvert.model.Eac3StereoDownmix? = null
        /**
         * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
         */
        var surroundExMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3SurroundExMode? = null
        /**
         * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
         */
        var surroundMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3SurroundMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings) : this() {
            this.attenuationControl = x.attenuationControl
            this.bitrate = x.bitrate
            this.bitstreamMode = x.bitstreamMode
            this.codingMode = x.codingMode
            this.dcFilter = x.dcFilter
            this.dialnorm = x.dialnorm
            this.dynamicRangeCompressionLine = x.dynamicRangeCompressionLine
            this.dynamicRangeCompressionRf = x.dynamicRangeCompressionRf
            this.lfeControl = x.lfeControl
            this.lfeFilter = x.lfeFilter
            this.loRoCenterMixLevel = x.loRoCenterMixLevel
            this.loRoSurroundMixLevel = x.loRoSurroundMixLevel
            this.ltRtCenterMixLevel = x.ltRtCenterMixLevel
            this.ltRtSurroundMixLevel = x.ltRtSurroundMixLevel
            this.metadataControl = x.metadataControl
            this.passthroughControl = x.passthroughControl
            this.phaseControl = x.phaseControl
            this.sampleRate = x.sampleRate
            this.stereoDownmix = x.stereoDownmix
            this.surroundExMode = x.surroundExMode
            this.surroundMode = x.surroundMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings = Eac3Settings(this)
    }
}
